/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PacketDodge {
	public static final class_2960 ID = prefix("do");

	public static void send() {
		ClientPlayNetworking.send(ID, PacketHandler.EMPTY_BUF);
	}

	public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
		server.execute(() -> {
			player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.dash, class_3419.field_15248, 1F, 1F);

			class_1799 ringStack = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, player);
			if (ringStack.method_7960()) {
				player.field_13987.method_14367(new class_2588("botaniamisc.invalidDodge"));
				return;
			}

			player.method_7322(0.3F);
			ItemNBTHelper.setInt(ringStack, ItemDodgeRing.TAG_DODGE_COOLDOWN, ItemDodgeRing.MAX_CD);
		});
	}
}
