/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ItemTwigWand;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import io.netty.buffer.Unpooled;

// Prefer using World.addBlockEvent/Block.eventReceived/TileEntity.receiveClientEvent where possible
// as those use less network bandwidth (~14 bytes), vs 26+ bytes here
public class PacketBotaniaEffect {
	public static final class_2960 ID = prefix("eff");

	public static void send(class_1657 player, EffectType type, double x, double y, double z, int... args) {
		if (player instanceof class_3222) {
			((class_3222) player).field_13987.method_14364(make(type, x, y, z, args));
		}
	}

	public static void sendNearby(class_1297 e, EffectType type, double x, double y, double z, int... args) {
		if (!e.field_6002.field_9236) {
			class_2596<?> pkt = make(type, x, y, z, args);
			PlayerLookup.tracking(e).stream()
					.filter(p -> p.method_5707(e.method_19538()) < 64 * 64)
					.forEach(p -> p.field_13987.method_14364(pkt));
			if (e instanceof class_3222) {
				((class_3222) e).field_13987.method_14364(pkt);
			}
		}
	}

	public static void sendNearby(class_1937 world, class_2338 pos, EffectType type, double x, double y, double z, int... args) {
		if (world instanceof class_3218) {
			class_2596<?> pkt = make(type, x, y, z, args);
			PlayerLookup.tracking((class_3218) world, pos).stream()
					.filter(p -> p.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260()) < 64 * 64)
					.forEach(p -> p.field_13987.method_14364(pkt));
		}
	}

	public static class_2596<?> make(EffectType type, double x, double y, double z, int... args) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		buf.writeByte(type.ordinal());
		buf.writeDouble(x);
		buf.writeDouble(y);
		buf.writeDouble(z);

		for (int i = 0; i < type.argCount; i++) {
			buf.method_10804(args[i]);
		}

		return ServerPlayNetworking.createS2CPacket(ID, buf);
	}

	public static class Handler {
		public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
			EffectType type = EffectType.values()[buf.readByte()];
			double x = buf.readDouble();
			double y = buf.readDouble();
			double z = buf.readDouble();
			int[] args = new int[type.argCount];

			for (int i = 0; i < args.length; i++) {
				args[i] = buf.method_10816();
			}

			client.execute(new Runnable() {
				// Use anon - lambda causes classloading issues
				@Override
				public void run() {
					class_310 mc = class_310.method_1551();
					class_1937 world = mc.field_1687;
					switch (type) {
					case PAINT_LENS: {
						class_1767 placeColor = class_1767.method_7791(args[0]);
						int hex = ColorHelper.getColorValue(placeColor);
						int r = (hex & 0xFF0000) >> 16;
						int g = (hex & 0xFF00) >> 8;
						int b = hex & 0xFF;
						for (int i = 0; i < 10; i++) {
							class_2338 pos = new class_2338(x, y, z).method_10093(class_2350.method_10162(world.field_9229));
							SparkleParticleData data = SparkleParticleData.sparkle(0.6F + (float) Math.random() * 0.5F, r / 255F, g / 255F, b / 255F, 5);
							world.method_8406(data, pos.method_10263() + (float) Math.random(), pos.method_10264() + (float) Math.random(), pos.method_10260() + (float) Math.random(), 0, 0, 0);
						}
						break;
					}
					case ARENA_INDICATOR: {
						SparkleParticleData data = SparkleParticleData.sparkle(5F, 1, 0, 1, 120);
						for (int i = 0; i < 360; i += 8) {
							float rad = i * (float) Math.PI / 180F;
							double wx = x + 0.5 - Math.cos(rad) * EntityDoppleganger.ARENA_RANGE;
							double wy = y + 0.5;
							double wz = z + 0.5 - Math.sin(rad) * EntityDoppleganger.ARENA_RANGE;
							Botania.proxy.addParticleForceNear(world, data, wx, wy, wz, 0, 0, 0);
						}
						break;
					}
					case ITEM_SMOKE: {
						class_1297 item = world.method_8469(args[0]);
						if (item == null) {
							return;
						}

						int p = args[1];

						for (int i = 0; i < p; i++) {
							double m = 0.01;
							double d0 = item.field_6002.field_9229.nextGaussian() * m;
							double d1 = item.field_6002.field_9229.nextGaussian() * m;
							double d2 = item.field_6002.field_9229.nextGaussian() * m;
							double d3 = 10.0D;
							item.field_6002.method_8406(class_2398.field_11203,
									x + item.field_6002.field_9229.nextFloat() * item.method_17681() * 2.0F - item.method_17681() - d0 * d3, y + item.field_6002.field_9229.nextFloat() * item.method_17682() - d1 * d3,
									z + item.field_6002.field_9229.nextFloat() * item.method_17681() * 2.0F - item.method_17681() - d2 * d3, d0, d1, d2);
						}
						break;
					}
					case SPARK_NET_INDICATOR: {
						class_1297 e1 = world.method_8469(args[0]);
						class_1297 e2 = world.method_8469(args[1]);

						if (e1 == null || e2 == null) {
							return;
						}

						Vector3 orig = new Vector3(e1.method_23317(), e1.method_23318() + 0.25, e1.method_23321());
						Vector3 end = new Vector3(e2.method_23317(), e2.method_23318() + 0.25, e2.method_23321());
						Vector3 diff = end.subtract(orig);
						Vector3 movement = diff.normalize().multiply(0.1);
						int iters = (int) (diff.mag() / movement.mag());
						float huePer = 1F / iters;
						float hueSum = (float) Math.random();

						Vector3 currentPos = orig;
						for (int i = 0; i < iters; i++) {
							float hue = i * huePer + hueSum;
							int color = class_3532.method_15369(class_3532.method_22450(hue), 1F, 1F);
							float r = Math.min(1F, (color >> 16 & 0xFF) / 255F + 0.4F);
							float g = Math.min(1F, (color >> 8 & 0xFF) / 255F + 0.4F);
							float b = Math.min(1F, (color & 0xFF) / 255F + 0.4F);

							SparkleParticleData data = SparkleParticleData.noClip(1, r, g, b, 12);
							world.method_17452(data, true, currentPos.x, currentPos.y, currentPos.z, 0, 0, 0);
							currentPos = currentPos.add(movement);
						}

						break;
					}
					case SPARK_MANA_FLOW: {
						class_1297 e1 = world.method_8469(args[0]);
						class_1297 e2 = world.method_8469(args[1]);

						if (e1 == null || e2 == null) {
							return;
						}

						double rc = 0.45;
						Vector3 thisVec = Vector3.fromEntityCenter(e1).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
						Vector3 receiverVec = Vector3.fromEntityCenter(e2).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);

						Vector3 motion = receiverVec.subtract(thisVec).multiply(0.04F);
						float r = 0.4F + 0.3F * (float) Math.random();
						float g = 0.4F + 0.3F * (float) Math.random();
						float b = 0.4F + 0.3F * (float) Math.random();
						float size = 0.125F + 0.125F * (float) Math.random();

						WispParticleData data = WispParticleData.wisp(size, r, g, b).withNoClip(true);
						world.method_8494(data, thisVec.x, thisVec.y, thisVec.z, (float) motion.x, (float) motion.y, (float) motion.z);
						break;
					}
					case ENCHANTER_DESTROY: {
						for (int i = 0; i < 50; i++) {
							float red = (float) Math.random();
							float green = (float) Math.random();
							float blue = (float) Math.random();
							WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, red, green, blue);
							world.method_8406(data, x, y, z, (float) (Math.random() - 0.5F) * 0.25F, (float) (Math.random() - 0.5F) * 0.25F, (float) (Math.random() - 0.5F) * 0.25F);
						}
						break;
					}
					case BLACK_LOTUS_DISSOLVE: {
						for (int i = 0; i < 50; i++) {
							float r = (float) Math.random() * 0.35F;
							float g = 0F;
							float b = (float) Math.random() * 0.35F;
							float s = 0.45F * (float) Math.random() * 0.25F;

							float m = 0.045F;
							float mx = ((float) Math.random() - 0.5F) * m;
							float my = (float) Math.random() * m;
							float mz = ((float) Math.random() - 0.5F) * m;

							WispParticleData data = WispParticleData.wisp(s, r, g, b);
							world.method_8406(data, x, y, z, mx, my, mz);
						}

						break;
					}
					case TERRA_PLATE: {
						class_2586 te = world.method_8321(new class_2338(x, y, z));
						if (te instanceof TileTerraPlate) {
							float percentage = Float.intBitsToFloat(args[0]);
							int ticks = (int) (100.0 * percentage);

							int totalSpiritCount = 3;
							double tickIncrement = 360D / totalSpiritCount;

							int speed = 5;
							double wticks = ticks * speed - tickIncrement;

							double r = Math.sin((ticks - 100) / 10D) * 2;
							double g = Math.sin(wticks * Math.PI / 180 * 0.55);

							for (int i = 0; i < totalSpiritCount; i++) {
								double wx = x + Math.sin(wticks * Math.PI / 180) * r + 0.5;
								double wy = y + 0.25 + Math.abs(r) * 0.7;
								double wz = z + Math.cos(wticks * Math.PI / 180) * r + 0.5;

								wticks += tickIncrement;
								float[] colorsfx = new float[] {
										0F, (float) ticks / (float) 100, 1F - (float) ticks / (float) 100
								};
								WispParticleData data = WispParticleData.wisp(0.85F, colorsfx[0], colorsfx[1], colorsfx[2], 0.25F);
								Botania.proxy.addParticleForceNear(world, data, wx, wy, wz, 0, (float) (-g * 0.05), 0);
								data = WispParticleData.wisp((float) Math.random() * 0.1F + 0.1F, colorsfx[0], colorsfx[1], colorsfx[2], 0.9F);
								world.method_8406(data, wx, wy, wz, (float) (Math.random() - 0.5) * 0.05F, (float) (Math.random() - 0.5) * 0.05F, (float) (Math.random() - 0.5) * 0.05F);

								if (ticks == 100) {
									for (int j = 0; j < 15; j++) {
										data = WispParticleData.wisp((float) Math.random() * 0.15F + 0.15F, colorsfx[0], colorsfx[1], colorsfx[2]);
										world.method_8406(data, x + 0.5, y + 0.5, z + 0.5, (float) (Math.random() - 0.5F) * 0.125F, (float) (Math.random() - 0.5F) * 0.125F, (float) (Math.random() - 0.5F) * 0.125F);
									}
								}
							}
						}
						break;
					}
					case FLUGEL_EFFECT: {
						class_1297 entity = world.method_8469(args[0]);
						if (entity != null) {
							for (int i = 0; i < 15; i++) {
								float x = (float) (entity.method_23317() + Math.random());
								float y = (float) (entity.method_23318() + Math.random());
								float z = (float) (entity.method_23321() + Math.random());
								WispParticleData data = WispParticleData.wisp((float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), 1);
								world.method_8406(data, x, y, z, 0, -(-0.3F + (float) Math.random() * 0.2F), 0);
							}
						}
						break;
					}
					case PARTICLE_BEAM: {
						ItemTwigWand.doParticleBeam(class_310.method_1551().field_1687,
								new Vector3(x, y, z),
								new Vector3(args[0] + 0.5, args[1] + 0.5, args[2] + 0.5));
						break;
					}
					case DIVA_EFFECT: {
						class_1297 target = class_310.method_1551().field_1687.method_8469(args[0]);
						if (target == null) {
							break;
						}

						double x = target.method_23317();
						double y = target.method_23318();
						double z = target.method_23321();

						SparkleParticleData data = SparkleParticleData.sparkle(1F, 1F, 1F, 0.25F, 3);
						for (int i = 0; i < 50; i++) {
							world.method_8406(data, x + Math.random() * target.method_17681(), y + Math.random() * target.method_17682(), z + Math.random() * target.method_17681(), 0, 0, 0);
						}
						break;
					}
					case HALO_CRAFT: {
						class_1297 target = class_310.method_1551().field_1687.method_8469(args[0]);
						if (target != null) {
							class_243 lookVec3 = target.method_5720();
							Vector3 centerVector = Vector3.fromEntityCenter(target).add(lookVec3.field_1352 * 3, 1.3, lookVec3.field_1350 * 3);
							float m = 0.1F;
							for (int i = 0; i < 4; i++) {
								WispParticleData data = WispParticleData.wisp(0.2F + 0.2F * (float) Math.random(), 1F, 0F, 1F);
								target.field_6002.method_8406(data, centerVector.x, centerVector.y, centerVector.z, ((float) Math.random() - 0.5F) * m, ((float) Math.random() - 0.5F) * m, ((float) Math.random() - 0.5F) * m);
							}
						}

						break;
					}
					}
				}
			});
		}
	}

	public enum EffectType {
		PAINT_LENS(1), // Arg: EnumDyeColor
		ARENA_INDICATOR(0),
		ITEM_SMOKE(2), // Arg: Entity ID, number of particles
		SPARK_NET_INDICATOR(2), // Arg: Entity ID from, Entity ID towards
		SPARK_MANA_FLOW(2), // Arg: Entity ID from, Entity ID towards
		ENCHANTER_DESTROY(0),
		BLACK_LOTUS_DISSOLVE(0),
		TERRA_PLATE(1), // Arg: Completion proportion (transmuted from float)
		FLUGEL_EFFECT(1), // Arg: Entity ID
		PARTICLE_BEAM(3), // Args: dest xyz
		DIVA_EFFECT(1), // Arg: Entity ID
		HALO_CRAFT(1), // Arg: Entity ID
		;

		private final int argCount;

		EffectType(int argCount) {
			this.argCount = argCount;
		}
	}

}
