/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.lib;

import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import java.util.List;
import java.util.function.Function;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ModTags {
	private static <T> class_3494.class_5123<T> getOrRegister(List<? extends class_3494.class_5123<T>> list,
			Function<class_2960, class_3494.class_5123<T>> register,
			class_2960 loc) {
		for (class_3494.class_5123<T> existing : list) {
			if (existing.method_26791().equals(loc)) {
				return existing;
			}
		}

		return register.apply(loc);
	}

	public static class Items {
		public static final class_3494.class_5123<class_1792> DUSTS_MANA = tag("mana_dusts");

		public static final class_3494.class_5123<class_1792> GEMS_DRAGONSTONE = tag("dragonstone_gems");
		public static final class_3494.class_5123<class_1792> GEMS_MANA_DIAMOND = tag("mana_diamond_gems");

		public static final class_3494.class_5123<class_1792> INGOTS_ELEMENTIUM = tag("elementium_ingots");
		public static final class_3494.class_5123<class_1792> INGOTS_MANASTEEL = tag("manasteel_ingots");
		public static final class_3494.class_5123<class_1792> INGOTS_TERRASTEEL = tag("terrasteel_ingots");

		public static final class_3494.class_5123<class_1792> NUGGETS_ELEMENTIUM = tag("elementium_nuggets");
		public static final class_3494.class_5123<class_1792> NUGGETS_MANASTEEL = tag("manasteel_nuggets");
		public static final class_3494.class_5123<class_1792> NUGGETS_TERRASTEEL = tag("terrasteel_nuggets");

		public static final class_3494.class_5123<class_1792> BLOCKS_ELEMENTIUM = tag("elementium_blocks");
		public static final class_3494.class_5123<class_1792> BLOCKS_MANASTEEL = tag("manasteel_blocks");
		public static final class_3494.class_5123<class_1792> BLOCKS_QUARTZ = commonTag("quartz_blocks");
		public static final class_3494.class_5123<class_1792> BLOCKS_TERRASTEEL = tag("terrasteel_blocks");

		public static final class_3494.class_5123<class_1792> MYSTICAL_FLOWERS = tag("mystical_flowers");
		public static final class_3494.class_5123<class_1792> DOUBLE_MYSTICAL_FLOWERS = tag("double_mystical_flowers");

		public static final class_3494.class_5123<class_1792> CONTRIBUTOR_HEADFLOWERS = tag("contributor_headflowers");
		public static final class_3494.class_5123<class_1792> SPECIAL_FLOWERS = tag("special_flowers");
		public static final class_3494.class_5123<class_1792> MINI_FLOWERS = tag("mini_flowers");
		public static final class_3494.class_5123<class_1792> MISC_SPECIAL_FLOWERS = tag("misc_special_flowers");
		public static final class_3494.class_5123<class_1792> FUNCTIONAL_SPECIAL_FLOWERS = tag("functional_special_flowers");
		public static final class_3494.class_5123<class_1792> GENERATING_SPECIAL_FLOWERS = tag("generating_special_flowers");

		public static final class_3494.class_5123<class_1792> FLOATING_FLOWERS = tag("floating_flowers");
		public static final class_3494.class_5123<class_1792> MUNDANE_FLOATING_FLOWERS = tag("mundane_floating_flowers");
		public static final class_3494.class_5123<class_1792> SPECIAL_FLOATING_FLOWERS = tag("special_floating_flowers");

		public static final class_3494.class_5123<class_1792> LENS = tag("lens");
		public static final class_3494.class_5123<class_1792> LIVINGROCK = tag("livingrock");
		public static final class_3494.class_5123<class_1792> LIVINGWOOD = tag("livingwood");

		public static final class_3494.class_5123<class_1792> MAGNET_RING_BLACKLIST = tag("magnet_ring_blacklist");
		public static final class_3494.class_5123<class_1792> LOONIUM_BLACKLIST = tag("loonium_blacklist");

		public static final class_3494.class_5123<class_1792> DISPOSABLE = tag("disposable");
		public static final class_3494.class_5123<class_1792> SEMI_DISPOSABLE = tag("semi_disposable");

		public static final class_3494.class_5123<class_1792> PETALS = tag("petals");
		public static final class_3494.class_5123<class_1792> PETALS_BLACK = tag("petals/black");
		public static final class_3494.class_5123<class_1792> PETALS_BLUE = tag("petals/blue");
		public static final class_3494.class_5123<class_1792> PETALS_BROWN = tag("petals/brown");
		public static final class_3494.class_5123<class_1792> PETALS_CYAN = tag("petals/cyan");
		public static final class_3494.class_5123<class_1792> PETALS_GRAY = tag("petals/gray");
		public static final class_3494.class_5123<class_1792> PETALS_GREEN = tag("petals/green");
		public static final class_3494.class_5123<class_1792> PETALS_LIGHT_BLUE = tag("petals/light_blue");
		public static final class_3494.class_5123<class_1792> PETALS_LIGHT_GRAY = tag("petals/light_gray");
		public static final class_3494.class_5123<class_1792> PETALS_LIME = tag("petals/lime");
		public static final class_3494.class_5123<class_1792> PETALS_MAGENTA = tag("petals/magenta");
		public static final class_3494.class_5123<class_1792> PETALS_ORANGE = tag("petals/orange");
		public static final class_3494.class_5123<class_1792> PETALS_PINK = tag("petals/pink");
		public static final class_3494.class_5123<class_1792> PETALS_PURPLE = tag("petals/purple");
		public static final class_3494.class_5123<class_1792> PETALS_RED = tag("petals/red");
		public static final class_3494.class_5123<class_1792> PETALS_WHITE = tag("petals/white");
		public static final class_3494.class_5123<class_1792> PETALS_YELLOW = tag("petals/yellow");

		public static final class_3494.class_5123<class_1792> RUNES = tag("runes");

		public static final class_3494.class_5123<class_1792> RUNES_AIR = tag("runes/air");
		public static final class_3494.class_5123<class_1792> RUNES_AUTUMN = tag("runes/autumn");
		public static final class_3494.class_5123<class_1792> RUNES_EARTH = tag("runes/earth");
		public static final class_3494.class_5123<class_1792> RUNES_ENVY = tag("runes/envy");
		public static final class_3494.class_5123<class_1792> RUNES_FIRE = tag("runes/fire");
		public static final class_3494.class_5123<class_1792> RUNES_GLUTTONY = tag("runes/gluttony");
		public static final class_3494.class_5123<class_1792> RUNES_GREED = tag("runes/greed");
		public static final class_3494.class_5123<class_1792> RUNES_LUST = tag("runes/lust");
		public static final class_3494.class_5123<class_1792> RUNES_MANA = tag("runes/mana");
		public static final class_3494.class_5123<class_1792> RUNES_PRIDE = tag("runes/pride");
		public static final class_3494.class_5123<class_1792> RUNES_SLOTH = tag("runes/sloth");
		public static final class_3494.class_5123<class_1792> RUNES_SPRING = tag("runes/spring");
		public static final class_3494.class_5123<class_1792> RUNES_SUMMER = tag("runes/summer");
		public static final class_3494.class_5123<class_1792> RUNES_WATER = tag("runes/water");
		public static final class_3494.class_5123<class_1792> RUNES_WINTER = tag("runes/winter");
		public static final class_3494.class_5123<class_1792> RUNES_WRATH = tag("runes/wrath");

		public static final class_3494.class_5123<class_1792> BURST_VIEWERS = tag("burst_viewers");
		public static final class_3494.class_5123<class_1792> TERRA_PICK_BLACKLIST = tag("terra_pick_blacklist");

		public static class_3494.class_5123<class_1792> getPetalTag(class_1767 color) {
			switch (color) {
			default:
			case field_7952:
				return PETALS_WHITE;
			case field_7946:
				return PETALS_ORANGE;
			case field_7958:
				return PETALS_MAGENTA;
			case field_7951:
				return PETALS_LIGHT_BLUE;
			case field_7947:
				return PETALS_YELLOW;
			case field_7961:
				return PETALS_LIME;
			case field_7954:
				return PETALS_PINK;
			case field_7944:
				return PETALS_GRAY;
			case field_7967:
				return PETALS_LIGHT_GRAY;
			case field_7955:
				return PETALS_CYAN;
			case field_7945:
				return PETALS_PURPLE;
			case field_7966:
				return PETALS_BLUE;
			case field_7957:
				return PETALS_BROWN;
			case field_7942:
				return PETALS_GREEN;
			case field_7964:
				return PETALS_RED;
			case field_7963:
				return PETALS_BLACK;
			}
		}

		private static class_3494.class_5123<class_1792> tag(String name) {
			return TagRegistry.create(prefix(name), class_3489::method_15106);
		}

		private static class_3494.class_5123<class_1792> commonTag(String name) {
			return TagRegistry.create(new class_2960("c", name), class_3489::method_15106);
		}
	}

	public static class Blocks {
		public static final class_3494.class_5123<class_2248> MYSTICAL_FLOWERS = tag("mystical_flowers");
		public static final class_3494.class_5123<class_2248> DOUBLE_MYSTICAL_FLOWERS = tag("double_mystical_flowers");

		public static final class_3494.class_5123<class_2248> SPECIAL_FLOWERS = tag("special_flowers");
		public static final class_3494.class_5123<class_2248> MINI_FLOWERS = tag("mini_flowers");
		public static final class_3494.class_5123<class_2248> MISC_SPECIAL_FLOWERS = tag("misc_special_flowers");
		public static final class_3494.class_5123<class_2248> FUNCTIONAL_SPECIAL_FLOWERS = tag("functional_special_flowers");
		public static final class_3494.class_5123<class_2248> GENERATING_SPECIAL_FLOWERS = tag("generating_special_flowers");

		public static final class_3494.class_5123<class_2248> FLOATING_FLOWERS = tag("floating_flowers");
		public static final class_3494.class_5123<class_2248> MUNDANE_FLOATING_FLOWERS = tag("mundane_floating_flowers");
		public static final class_3494.class_5123<class_2248> SPECIAL_FLOATING_FLOWERS = tag("special_floating_flowers");

		public static final class_3494.class_5123<class_2248> LIVINGROCK = tag("livingrock");
		public static final class_3494.class_5123<class_2248> LIVINGWOOD = tag("livingwood");

		public static final class_3494.class_5123<class_2248> BLOCKS_ELEMENTIUM = tag("elementium_blocks");
		public static final class_3494.class_5123<class_2248> BLOCKS_MANASTEEL = tag("manasteel_blocks");
		public static final class_3494.class_5123<class_2248> BLOCKS_QUARTZ = commonTag("quartz_blocks");
		public static final class_3494.class_5123<class_2248> BLOCKS_TERRASTEEL = tag("terrasteel_blocks");

		public static final class_3494.class_5123<class_2248> GAIA_BREAK_BLACKLIST = tag("gaia_break_blacklist");
		public static final class_3494.class_5123<class_2248> MAGNET_RING_BLACKLIST = tag("magnet_ring_blacklist");

		public static final class_3494.class_5123<class_2248> TERRAFORMABLE = tag("terraformable");

		public static final class_3494.class_5123<class_2248> CORPOREA_SPARK_OVERRIDE = tag("corporea_spark_override");
		public static final class_3494.class_5123<class_2248> TERRA_PLATE_BASE = tag("terra_plate_base");

		public static final class_3494.class_5123<class_2248> LAPIS_BLOCKS = commonTag("lapis_blocks");

		private static class_3494.class_5123<class_2248> tag(String name) {
			return TagRegistry.create(prefix(name), class_3481::method_15073);
		}

		private static class_3494.class_5123<class_2248> commonTag(String name) {
			return TagRegistry.create(new class_2960("c", name), class_3481::method_15073);
		}
	}

	public static class Entities {
		public static final class_3494.class_5123<class_1299<?>> SHADED_MESA_BLACKLIST = tag("shaded_mesa_blacklist");

		public static final class_3494.class_5123<class_1299<?>> COCOON_COMMON = tag("cocoon/common");
		public static final class_3494.class_5123<class_1299<?>> COCOON_RARE = tag("cocoon/rare");
		public static final class_3494.class_5123<class_1299<?>> COCOON_COMMON_AQUATIC = tag("cocoon/common_aquatic");
		public static final class_3494.class_5123<class_1299<?>> COCOON_RARE_AQUATIC = tag("cocoon/rare_aquatic");

		private static class_3494.class_5123<class_1299<?>> tag(String name) {
			return TagRegistry.create(prefix(name), class_3483::method_15082);
		}
	}
}
