/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ItemWaterRod extends class_1792 implements IManaUsingItem {

	public static final int COST = 75;

	public ItemWaterRod(class_1793 props) {
		super(props);
	}

	// [VanillaCopy] From BucketItem
	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, @Nonnull class_1268 handIn) {
		class_1799 itemstack = playerIn.method_5998(handIn);
		class_239 raytraceresult = method_7872(worldIn, playerIn, class_3959.class_242.field_1348);
		if (raytraceresult.method_17783() == class_239.class_240.field_1333) {
			return new class_1271<>(class_1269.field_5811, itemstack);
		} else if (raytraceresult.method_17783() != class_239.class_240.field_1332) {
			return new class_1271<>(class_1269.field_5811, itemstack);
		} else {
			class_3965 blockraytraceresult = (class_3965) raytraceresult;
			class_2338 blockpos = blockraytraceresult.method_17777();
			if (worldIn.method_8505(playerIn, blockpos) && playerIn.method_7343(blockpos, blockraytraceresult.method_17780(), itemstack)) {
				class_2680 blockstate = worldIn.method_8320(blockpos);
				class_2338 blockpos1 = blockstate.method_26204() instanceof class_2402 ? blockpos : blockraytraceresult.method_17777().method_10093(blockraytraceresult.method_17780());
				if (ManaItemHandler.instance().requestManaExactForTool(itemstack, playerIn, COST, true)
						&& ((class_1755) class_1802.field_8705).method_7731(playerIn, worldIn, blockpos1, blockraytraceresult)) {
					if (playerIn instanceof class_3222) {
						class_174.field_1191.method_9087((class_3222) playerIn, blockpos1, itemstack);
					}

					playerIn.method_7259(class_3468.field_15372.method_14956(this));
					SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.2F, 0.2F, 1F, 5);
					for (int i = 0; i < 6; i++) {
						playerIn.field_6002.method_8406(data, blockpos1.method_10263() + Math.random(), blockpos1.method_10264() + Math.random(), blockpos1.method_10260() + Math.random(), 0, 0, 0);
					}
					return new class_1271<>(class_1269.field_5812, itemstack);
				} else {
					return new class_1271<>(class_1269.field_5814, itemstack);
				}
			} else {
				return new class_1271<>(class_1269.field_5814, itemstack);
			}
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

}
