/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import java.util.List;

public class ItemTornadoRod extends class_1792 implements IManaUsingItem, IAvatarWieldable {

	private static final class_2960 avatarOverlay = new class_2960(LibResources.MODEL_AVATAR_TORNADO);

	private static final int FLY_TIME = 20;
	private static final int FALL_MULTIPLIER = 3;
	private static final int MAX_COUNTER = FLY_TIME * FALL_MULTIPLIER;
	private static final int COST = 350;

	private static final String TAG_FLYING = "flying";
	private static final String TAG_FLYCOUNTER = "flyCounter";

	public ItemTornadoRod(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 ent, int slot, boolean active) {
		if (ent instanceof class_1657) {
			class_1657 player = (class_1657) ent;
			boolean damaged = getFlyCounter(stack) > 0;
			boolean held = player.method_6047() == stack || player.method_6079() == stack;

			if (damaged && !isFlying(stack)) {
				setFlyCounter(stack, getFlyCounter(stack) - 1);
			}

			if (getFlyCounter(stack) >= MAX_COUNTER) {
				setFlying(stack, false);
			} else if (isFlying(stack)) {
				if (held) {
					player.field_6017 = 0F;
					double my = IManaProficiencyArmor.hasProficiency(player, stack) ? 1.6 : 1.25;
					class_243 oldMot = player.method_18798();
					player.method_18799(new class_243(oldMot.method_10216(), my, oldMot.method_10215()));

					player.method_5783(ModSounds.airRod, 0.1F, 0.25F);
					for (int i = 0; i < 5; i++) {
						WispParticleData data = WispParticleData.wisp(0.35F + (float) Math.random() * 0.1F, 0.25F, 0.25F, 0.25F);
						world.method_8406(data, player.method_23317(), player.method_23318(), player.method_23321(), 0.2F * (float) (Math.random() - 0.5), -0.01F * (float) Math.random(), 0.2F * (float) (Math.random() - 0.5));
					}
				}

				setFlyCounter(stack, getFlyCounter(stack) + FALL_MULTIPLIER);
				if (getFlyCounter(stack) == MAX_COUNTER) {
					setFlying(stack, false);
				}
			}

			if (damaged) {
				player.field_6017 = 0;
			}
		}
	}

	/* todo 1.16-fabric
	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		return getFlyCounter(stack) > 0;
	}
	
	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		return getFlyCounter(stack) / (double) MAX_COUNTER;
	}
	*/

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int fly = getFlyCounter(stack);
		if (fly == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
			ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);
			setFlying(stack, true);
			return class_1271.method_22427(stack);
		}

		return class_1271.method_22430(stack);
	}

	public static boolean isFlying(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
	}

	private void setFlying(class_1799 stack, boolean flying) {
		ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
	}

	private int getFlyCounter(class_1799 stack) {
		return stack.method_7948().method_10550(TAG_FLYCOUNTER);
	}

	private void setFlyCounter(class_1799 stack, int counter) {
		stack.method_7948().method_10569(TAG_FLYCOUNTER, counter);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public void onAvatarUpdate(IAvatarTile tile, class_1799 stack) {
		class_2586 te = tile.tileEntity();
		class_1937 world = te.method_10997();
		if (tile.getCurrentMana() >= COST && tile.isEnabled()) {
			int range = 5;
			int rangeY = 3;
			List<class_1657> players = world.method_18467(class_1657.class, new class_238(te.method_11016().method_10080(-0.5 - range, -0.5 - rangeY, -0.5 - range), te.method_11016().method_10080(0.5 + range, 0.5 + rangeY, 0.5 + range)));
			for (class_1657 p : players) {
				if (p.method_18798().method_10214() > 0.3 && p.method_18798().method_10214() < 2 && !p.method_5715()) {
					p.method_18800(p.method_18798().method_10216(), 2.8, p.method_18798().method_10215());

					for (int i = 0; i < 20; i++) {
						for (int j = 0; j < 5; j++) {
							WispParticleData data = WispParticleData.wisp(0.35F + (float) Math.random() * 0.1F, 0.25F, 0.25F, 0.25F);
							world.method_8406(data, p.method_23317(), p.method_23318() + i, p.method_23321(), 0.2F * (float) (Math.random() - 0.5), -0.01F * (float) Math.random(), 0.2F * (float) (Math.random() - 0.5));
						}
					}

					if (!world.field_9236) {
						p.field_6002.method_8465(null, p.method_23317(), p.method_23318(), p.method_23321(), ModSounds.dash, class_3419.field_15248, 1F, 1F);
						p.method_6092(new class_1293(ModPotions.featherfeet, 100, 0));
						tile.receiveMana(-COST);
					}
				}
			}
		}
	}

	/* todo 1.16-fabric FAPI#860
	@Override
	public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
		return newStack.getItem() != this || isFlying(oldStack) != isFlying(newStack);
	}
	*/

	@Override
	public class_2960 getOverlayResource(IAvatarTile tile, class_1799 stack) {
		return avatarOverlay;
	}

}
