/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

public class ItemTerraformRod extends class_1792 implements IManaUsingItem, IBlockProvider {
	private static final int COST_PER = 55;

	public ItemTerraformRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Override
	public void method_7852(@Nonnull class_1937 world, @Nonnull class_1309 living, @Nonnull class_1799 stack, int count) {
		if (count != method_7881(stack) && count % 10 == 0 && living instanceof class_1657) {
			terraform(stack, world, (class_1657) living);
		}
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		player.method_6019(hand);
		return class_1271.method_22428(player.method_5998(hand));
	}

	private void terraform(class_1799 stack, class_1937 world, class_1657 player) {
		int range = IManaProficiencyArmor.hasProficiency(player, stack) ? 22 : 16;

		class_2338 startCenter = player.method_24515().method_10074();

		if (startCenter.method_10264() < world.method_8615()) // Not below sea level
		{
			return;
		}

		List<CoordsWithBlock> blocks = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(startCenter.method_10069(-range, -range, -range), startCenter.method_10069(range, range, range))) {
			class_2680 state = world.method_8320(pos);
			if (state.method_26215()) {
				continue;
			}

			if (ModTags.Blocks.TERRAFORMABLE.method_15141(state.method_26204())) {
				List<class_2338> airBlocks = new ArrayList<>();

				for (class_2350 dir : class_2350.class_2353.field_11062) {
					class_2338 pos_ = pos.method_10093(dir);
					class_2680 state_ = world.method_8320(pos_);
					class_2248 block_ = state_.method_26204();
					if (state_.method_26215() || state_.method_26207().method_15800()
							|| block_ instanceof class_2356 && !block_.method_9525(ModTags.Blocks.SPECIAL_FLOWERS)
							|| block_ instanceof class_2320) {
						airBlocks.add(pos_);
					}
				}

				if (!airBlocks.isEmpty()) {
					if (pos.method_10264() > startCenter.method_10264()) {
						blocks.add(new CoordsWithBlock(pos, class_2246.field_10124));
					} else {
						for (class_2338 coords : airBlocks) {
							if (!world.method_22347(coords.method_10074())) {
								blocks.add(new CoordsWithBlock(coords, class_2246.field_10566));
							}
						}
					}
				}
			}
		}

		int cost = COST_PER * blocks.size();

		if (world.field_9236 || ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true)) {
			if (!world.field_9236) {
				for (CoordsWithBlock block : blocks) {
					world.method_8501(block, block.block.method_9564());
				}
			}

			if (!blocks.isEmpty()) {
				for (int i = 0; i < 10; i++) {
					world.method_8465(player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14677, class_3419.field_15245, 1F, 0.4F);
				}
				SparkleParticleData data = SparkleParticleData.sparkle(2F, 0.35F, 0.2F, 0.05F, 5);
				for (int i = 0; i < 120; i++) {
					world.method_8406(data, startCenter.method_10263() - range + range * 2 * Math.random(), startCenter.method_10264() + 2 + (Math.random() - 0.5) * 2, startCenter.method_10260() - range + range * 2 * Math.random(), 0, 0, 0);
				}
			}
		}
	}

	private static class CoordsWithBlock extends class_2338 {

		private final class_2248 block;

		private CoordsWithBlock(class_2338 pos, class_2248 block) {
			super(pos);
			this.block = block;
		}

	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public boolean provideBlock(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block, boolean doit) {
		if (block == class_2246.field_10566) {
			return !doit || ManaItemHandler.instance().requestManaExactForTool(requestor, player, ItemDirtRod.COST, true);
		}
		return false;
	}

	@Override
	public int getBlockCount(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block) {
		if (block == class_2246.field_10566) {
			return -1;
		}
		return 0;
	}
}
