/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.material.ItemSelfReturning;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import java.util.List;

public class ItemRainbowRod extends ItemSelfReturning implements IManaUsingItem, IAvatarWieldable {

	private static final class_2960 avatarOverlay = new class_2960(LibResources.MODEL_AVATAR_RAINBOW);

	private static final int MANA_COST = 750;
	private static final int MANA_COST_AVATAR = 10;
	private static final int TIME = 600;

	public ItemRainbowRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!world.field_9236 && ManaItemHandler.instance().requestManaExactForTool(stack, player, MANA_COST, false)) {
			class_2248 place = ModBlocks.bifrost;
			Vector3 vector = new Vector3(player.method_5720()).normalize();

			double x = player.method_23317();
			double y = player.method_23318();
			double z = player.method_23321();
			class_2338.class_2339 pos = new class_2338.class_2339((int) x, (int) y, (int) z);

			double lastX = 0;
			double lastY = -1;
			double lastZ = 0;
			class_2338.class_2339 lastChecker = new class_2338.class_2339();

			int count = 0;
			boolean prof = IManaProficiencyArmor.hasProficiency(player, stack);
			int maxlen = prof ? 160 : 100;
			int time = prof ? (int) (TIME * 1.6) : TIME;

			class_2338.class_2339 placePos = new class_2338.class_2339();
			while (count < maxlen) {
				lastChecker.method_10102(lastX, lastY, lastZ);

				if (!lastChecker.equals(pos)) {
					if (y >= world.method_8322() || y <= 0
							|| !world.method_22347(pos) && world.method_8320(pos).method_26204() != place) {
						break;
					}

					for (int i = -2; i < 1; i++) {
						for (int j = -2; j < 1; j++) {
							placePos.method_10103(pos.method_10263() + i, pos.method_10264(), pos.method_10260() + j);
							if (world.method_22347(placePos)
									|| world.method_8320(placePos).method_26204() == place) {
								world.method_8652(placePos, place.method_9564(), 2);
								TileBifrost tile = (TileBifrost) world.method_8321(placePos);
								if (tile != null) {
									tile.ticks = time;
								}
							}

						}
					}
					count++;
				}

				lastX = x;
				lastY = y;
				lastZ = z;

				x += vector.x;
				y += vector.y;
				z += vector.z;
				pos.method_10102(x, y, z);
			}

			if (count > 0) {
				world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.bifrostRod, class_3419.field_15248, 0.5F, 0.25F);
				ManaItemHandler.instance().requestManaExactForTool(stack, player, MANA_COST, false);
				player.method_7357().method_7906(this, TIME);
			}
		}

		return class_1271.method_22427(stack);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public void onAvatarUpdate(IAvatarTile tile, class_1799 stack) {
		class_2586 te = tile.tileEntity();
		class_1937 world = te.method_10997();

		if (world.field_9236 || tile.getCurrentMana() < MANA_COST_AVATAR * 25 || !tile.isEnabled()) {
			return;
		}

		class_2338 tePos = te.method_11016();
		int w = 1;
		int h = 1;
		int l = 20;

		class_238 axis = null;
		switch (world.method_8320(tePos).method_11654(class_2741.field_12481)) {
		case field_11043:
			axis = new class_238(tePos.method_10069(-w, -h, -l), tePos.method_10069(w + 1, h, 0));
			break;
		case field_11035:
			axis = new class_238(tePos.method_10069(-w, -h, 1), tePos.method_10069(w + 1, h, l + 1));
			break;
		case field_11039:
			axis = new class_238(tePos.method_10069(-l, -h, -w), tePos.method_10069(0, h, w + 1));
			break;
		case field_11034:
			axis = new class_238(tePos.method_10069(1, -h, -w), tePos.method_10069(l + 1, h, w + 1));
			break;
		default:
		}

		List<class_1657> players = world.method_18467(class_1657.class, axis);
		for (class_1657 p : players) {
			int px = class_3532.method_15357(p.method_23317());
			int py = class_3532.method_15357(p.method_23318()) - 1;
			int pz = class_3532.method_15357(p.method_23321());
			int dist = 5;
			int diff = dist / 2;

			for (int i = 0; i < dist; i++) {
				for (int j = 0; j < dist; j++) {
					int ex = px + i - diff;
					int ez = pz + j - diff;

					if (!axis.method_1006(new class_243(ex + 0.5, py + 1, ez + 0.5))) {
						continue;
					}
					class_2338 pos = new class_2338(ex, py, ez);
					class_2248 block = world.method_8320(pos).method_26204();
					if (world.method_8320(pos).method_26215()) {
						world.method_8501(pos, ModBlocks.bifrost.method_9564());
						TileBifrost tileBifrost = (TileBifrost) world.method_8321(pos);
						tileBifrost.ticks = 10;
						tile.receiveMana(-MANA_COST_AVATAR);
					} else if (block == ModBlocks.bifrost) {
						TileBifrost tileBifrost = (TileBifrost) world.method_8321(pos);
						if (tileBifrost.ticks < 2) {
							tileBifrost.ticks = 10;
							tile.receiveMana(-MANA_COST_AVATAR);
						}
					}
				}
			}
		}

	}

	@Override
	public class_2960 getOverlayResource(IAvatarTile tile, class_1799 stack) {
		return avatarOverlay;
	}

}
