/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityThrownItem;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3494;
import java.util.ArrayList;
import java.util.List;

public class ItemGravityRod extends class_1792 implements IManaUsingItem {
	private static final class_3494.class_5123<class_1299<?>> BLACKLIST = ModTags.Entities.SHADED_MESA_BLACKLIST;
	private static final float RANGE = 3F;
	private static final int COST = 2;

	private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
	private static final String TAG_TICKS_COOLDOWN = "ticksCooldown";
	private static final String TAG_TARGET = "target";
	private static final String TAG_DIST = "dist";

	public ItemGravityRod(class_1793 props) {
		super(props);
	}

	/* todo fabric
	@Override
	public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
		return newStack.getItem() != this;
	}
	*/

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
		if (!(entity instanceof class_1657)) {
			return;
		}

		int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
		int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);

		if (ticksTillExpire == 0) {
			ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
			ItemNBTHelper.setDouble(stack, TAG_DIST, -1);
		}

		if (ticksCooldown > 0) {
			ticksCooldown--;
		}

		if (ticksTillExpire >= 0) {
			ticksTillExpire--;
		}
		ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
		ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, ticksCooldown);
	}

	public static void onEntitySwing(class_1309 entity) {
		if (!(entity instanceof class_1657)) {
			return;
		}
		class_1657 player = (class_1657) entity;
		leftClick(player);
	}

	/* todo fabric
	// Prevent damaging the entity you just held with the rod
	@Override
	public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
		return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
	}
	*/

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
		int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
		double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1);

		if (ticksCooldown == 0) {
			class_1297 target = null;
			if (targetID != -1 && player.field_6002.method_8469(targetID) != null) {
				class_1297 taritem = player.field_6002.method_8469(targetID);

				boolean found = false;
				Vector3 targetVec = Vector3.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					targetVec = targetVec.add(new Vector3(player.method_5720()).multiply(distance)).add(0, 0.5, 0);
					entities = player.field_6002.method_8335(player, new class_238(targetVec.x - RANGE, targetVec.y - RANGE, targetVec.z - RANGE, targetVec.x + RANGE, targetVec.y + RANGE, targetVec.z + RANGE));
					distance++;
					if (entities.contains(taritem)) {
						found = true;
					}
				}

				if (found) {
					target = player.field_6002.method_8469(targetID);
				}
			}

			if (target == null) {
				Vector3 targetVec = Vector3.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					targetVec = targetVec.add(new Vector3(player.method_5720()).multiply(distance)).add(0, 0.5, 0);
					entities = player.field_6002.method_8335(player, new class_238(targetVec.x - RANGE, targetVec.y - RANGE, targetVec.z - RANGE, targetVec.x + RANGE, targetVec.y + RANGE, targetVec.z + RANGE));
					distance++;
				}

				if (entities.size() > 0) {
					target = entities.get(0);
					length = 5.5D;
					if (target instanceof class_1542) {
						length = 2.0D;
					}
				}
			}

			if (target != null) {
				if (BLACKLIST.method_15141(target.method_5864())) {
					return class_1271.method_22431(stack);
				}

				if (ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true)) {
					if (target instanceof class_1542) {
						((class_1542) target).method_6982(5);
					}

					if (target instanceof class_1309) {
						class_1309 targetEntity = (class_1309) target;
						targetEntity.field_6017 = 0.0F;
						if (targetEntity.method_6112(class_1294.field_5909) == null) {
							targetEntity.method_6092(new class_1293(class_1294.field_5909, 2, 3, true, true));
						}
					}

					Vector3 target3 = Vector3.fromEntityCenter(player)
							.add(new Vector3(player.method_5720()).multiply(length)).add(0, 0.5, 0);
					if (target instanceof class_1542) {
						target3 = target3.add(0, 0.25, 0);
					}

					for (int i = 0; i < 4; i++) {
						float r = 0.5F + (float) Math.random() * 0.5F;
						float b = 0.5F + (float) Math.random() * 0.5F;
						float s = 0.2F + (float) Math.random() * 0.1F;
						float m = 0.1F;
						float xm = ((float) Math.random() - 0.5F) * m;
						float ym = ((float) Math.random() - 0.5F) * m;
						float zm = ((float) Math.random() - 0.5F) * m;
						WispParticleData data = WispParticleData.wisp(s, r, 0F, b);
						world.method_8406(data, target.method_23317() + target.method_17681() / 2, target.method_23318() + target.method_17682() / 2, target.method_23321() + target.method_17681() / 2, xm, ym, zm);
					}

					MathHelper.setEntityMotionFromVector(target, target3, 0.3333333F);

					ItemNBTHelper.setInt(stack, TAG_TARGET, target.method_5628());
					ItemNBTHelper.setDouble(stack, TAG_DIST, length);
				}

				ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
				return class_1271.method_22428(stack);
			}
		}
		return class_1271.method_22430(stack);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	private static void leftClick(class_1657 player) {
		class_1799 stack = player.method_6047();
		if (!stack.method_7960() && stack.method_7909() == ModItems.gravityRod) {
			int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
			ItemNBTHelper.getDouble(stack, TAG_DIST, -1);
			class_1297 item;

			if (targetID != -1 && player.field_6002.method_8469(targetID) != null) {
				class_1297 taritem = player.field_6002.method_8469(targetID);

				boolean found = false;
				Vector3 target = Vector3.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					target = target.add(new Vector3(player.method_5720()).multiply(distance)).add(0, 0.5, 0);
					entities = player.field_6002.method_8335(player, new class_238(target.x - RANGE, target.y - RANGE, target.z - RANGE, target.x + RANGE, target.y + RANGE, target.z + RANGE));
					distance++;
					if (entities.contains(taritem)) {
						found = true;
					}
				}

				if (found) {
					item = taritem;
					ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
					ItemNBTHelper.setDouble(stack, TAG_DIST, -1);
					Vector3 moveVector = new Vector3(player.method_5720().method_1029());
					if (item instanceof class_1542) {
						((class_1542) item).method_6982(20);
						float mot = IManaProficiencyArmor.hasProficiency(player, stack) ? 2.25F : 1.5F;
						item.method_18800(moveVector.x * mot, moveVector.y, moveVector.z * mot);
						if (!player.field_6002.field_9236) {
							EntityThrownItem thrown = new EntityThrownItem(item.field_6002, item.method_23317(), item.method_23318(), item.method_23321(), (class_1542) item);
							item.field_6002.method_8649(thrown);
						}
						item.method_5650();
					} else {
						item.method_18799(moveVector.multiply(3, 1.5, 3).toVector3d());
					}
					ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, 10);
				}
			}
		}
	}
}
