/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.entity.ModEntities;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ItemFireRod extends class_1792 implements IManaUsingItem, IAvatarWieldable {

	private static final class_2960 avatarOverlay = new class_2960(LibResources.MODEL_AVATAR_FIRE);

	private static final int COST = 900;
	private static final int COOLDOWN = 1200;

	public ItemFireRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();
		class_1799 stack = ctx.method_8041();
		class_2338 pos = ctx.method_8037();

		if (!world.field_9236 && player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
			EntityFlameRing entity = ModEntities.FLAME_RING.method_5883(world);
			entity.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5);
			world.method_8649(entity);

			player.method_7357().method_7906(this, IManaProficiencyArmor.hasProficiency(player, stack) ? COOLDOWN / 2 : COOLDOWN);
			ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);

			ctx.method_8045().method_8465(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), class_3417.field_14991, player != null ? class_3419.field_15248 : class_3419.field_15245, 1F, 1F);
		}

		return class_1269.field_5812;
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public void onAvatarUpdate(IAvatarTile tile, class_1799 stack) {
		class_2586 te = tile.tileEntity();
		class_1937 world = te.method_10997();

		if (!world.field_9236 && tile.getCurrentMana() >= COST && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
			EntityFlameRing entity = ModEntities.FLAME_RING.method_5883(world);
			entity.method_5814(te.method_11016().method_10263() + 0.5, te.method_11016().method_10264(), te.method_11016().method_10260() + 0.5);
			world.method_8649(entity);
			tile.receiveMana(-COST);
		}
	}

	@Override
	public class_2960 getOverlayResource(IAvatarTile tile, class_1799 stack) {
		return avatarOverlay;
	}

}
