/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.core.helper.ItemNBTHelper;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

public class ItemExchangeRod extends class_1792 implements IManaUsingItem, IWireframeCoordinateListProvider {

	private static final int RANGE = 3;
	private static final int COST = 40;

	private static final String TAG_BLOCK_NAME = "blockName";
	private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
	private static final String TAG_SWAPPING = "swapping";
	private static final String TAG_SELECT_X = "selectX";
	private static final String TAG_SELECT_Y = "selectY";
	private static final String TAG_SELECT_Z = "selectZ";
	private static final String TAG_EXTRA_RANGE = "extraRange";

	public ItemExchangeRod(class_1793 props) {
		super(props);
		AttackBlockCallback.EVENT.register(this::onLeftClick);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1657 player = ctx.method_8036();
		class_1799 stack = ctx.method_8041();
		class_2680 wstate = world.method_8320(pos);

		if (player != null && player.method_5715()) {
			class_2586 tile = world.method_8321(pos);
			if (tile == null) {
				if (BlockPlatform.isValidBlock(wstate, world, pos)) {
					setBlock(stack, wstate);

					displayRemainderCounter(player, stack);
					return class_1269.field_5812;
				}
			}
		} else if (canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
			class_2680 state = getState(stack);
			List<class_2338> swap = getTargetPositions(world, stack, state, pos, wstate.method_26204());
			if (swap.size() > 0) {
				ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
				ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.method_10263());
				ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.method_10264());
				ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.method_10260());
				setTarget(stack, wstate.method_26204());
			}
		}

		return class_1269.field_5812;
	}

	private class_1269 onLeftClick(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
		class_1799 stack = player.method_5998(hand);
		if (!player.method_7325() && !stack.method_7960() && stack.method_7909() == this && canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
			if (exchange(world, player, pos, stack, getState(stack))) {
				ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);
				return class_1269.field_5812;
			}
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean equipped) {
		if (!canExchange(stack) || !(entity instanceof class_1657)) {
			return;
		}

		class_1657 player = (class_1657) entity;

		int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
		int extraRangeNew = IManaProficiencyArmor.hasProficiency(player, stack) ? 3 : 1;
		if (extraRange != extraRangeNew) {
			ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
		}

		class_2680 state = getState(stack);
		if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
			if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
				ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
				return;
			}

			int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
			int y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0);
			int z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0);
			class_2248 target = getTargetState(stack);
			List<class_2338> swap = getTargetPositions(world, stack, state, new class_2338(x, y, z), target);
			if (swap.size() == 0) {
				ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
				return;
			}

			class_2338 coords = swap.get(world.field_9229.nextInt(swap.size()));
			boolean exchange = exchange(world, player, coords, stack, state);
			if (exchange) {
				ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);
			} else {
				ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
			}
		}
	}

	public List<class_2338> getTargetPositions(class_1937 world, class_1799 stack, class_2680 toPlace, class_2338 pos, class_2248 toReplace) {
		// Our result list
		List<class_2338> coordsList = new ArrayList<>();

		// We subtract 1 from the effective range as the center tile is included
		// So, with a range of 3, we are visiting tiles at -2, -1, 0, 1, 2
		int effRange = RANGE + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;

		// Iterate in all 3 dimensions through our possible positions.
		for (int offsetX = -effRange; offsetX <= effRange; offsetX++) {
			for (int offsetY = -effRange; offsetY <= effRange; offsetY++) {
				for (int offsetZ = -effRange; offsetZ <= effRange; offsetZ++) {
					class_2338 pos_ = pos.method_10069(offsetX, offsetY, offsetZ);

					class_2680 currentState = world.method_8320(pos_);

					// If this block is not our target, ignore it, as we don't need
					// to consider replacing it
					if (currentState.method_26204() != toReplace) {
						continue;
					}

					// If this block is already the block we're swapping to,
					// we don't need to swap again
					if (currentState == toPlace) {
						continue;
					}

					// Check to see if the block is visible on any side:
					for (class_2350 dir : class_2350.values()) {
						class_2338 adjPos = pos_.method_10093(dir);
						class_2680 adjState = world.method_8320(adjPos);

						if (!class_2248.method_9501(adjState.method_26222(world, pos), dir.method_10153())) {
							coordsList.add(pos_);
							break;
						}
					}
				}
			}
		}

		return coordsList;
	}

	public boolean exchange(class_1937 world, class_1657 player, class_2338 pos, class_1799 stack, class_2680 state) {
		class_2586 tile = world.method_8321(pos);
		if (tile != null) {
			return false;
		}

		class_1799 placeStack = removeFromInventory(player, stack, state.method_26204(), false);
		if (!placeStack.method_7960()) {
			class_2680 stateAt = world.method_8320(pos);
			if (!stateAt.method_26215() && stateAt.method_26165(player, world, pos) > 0 && stateAt != state) {
				if (!world.field_9236) {
					world.method_22352(pos, !player.field_7503.field_7477);
					if (!player.field_7503.field_7477) {
						removeFromInventory(player, stack, state.method_26204(), true);
					}
					world.method_8501(pos, state);
					state.method_26204().method_9567(world, pos, state, player, placeStack);
				}
				displayRemainderCounter(player, stack);
				return true;
			}
		}

		return false;
	}

	public boolean canExchange(class_1799 stack) {
		return !getState(stack).method_26215();
	}

	public static class_1799 removeFromInventory(class_1657 player, class_1263 inv, class_1799 stack, class_2248 block, boolean doit) {
		List<class_1799> providers = new ArrayList<>();
		for (int i = inv.method_5439() - 1; i >= 0; i--) {
			class_1799 invStack = inv.method_5438(i);
			if (invStack.method_7960()) {
				continue;
			}

			class_1792 item = invStack.method_7909();
			if (item == block.method_8389()) {
				class_1799 ret;
				if (doit) {
					ret = inv.method_5434(i, 1);
				} else {
					ret = invStack.method_7972();
					ret.method_7939(1);
				}
				return ret;
			}

			if (item instanceof IBlockProvider) {
				providers.add(invStack);
			}
		}

		for (class_1799 provStack : providers) {
			IBlockProvider prov = (IBlockProvider) provStack.method_7909();
			if (prov.provideBlock(player, stack, provStack, block, doit)) {
				return new class_1799(block);
			}
		}

		return class_1799.field_8037;
	}

	public static class_1799 removeFromInventory(class_1657 player, class_1799 stack, class_2248 block, boolean doit) {
		if (player.field_7503.field_7477) {
			return new class_1799(block);
		}

		class_1799 outStack = removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, block, doit);
		if (outStack.method_7960()) {
			outStack = removeFromInventory(player, player.field_7514, stack, block, doit);
		}
		return outStack;
	}

	public static int getInventoryItemCount(class_1657 player, class_1799 stack, class_2248 block) {
		if (player.field_7503.field_7477) {
			return -1;
		}

		int baubleCount = getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, block);
		if (baubleCount == -1) {
			return -1;
		}

		int count = getInventoryItemCount(player, player.field_7514, stack, block);
		if (count == -1) {
			return -1;
		}

		return count + baubleCount;
	}

	public static int getInventoryItemCount(class_1657 player, class_1263 inv, class_1799 stack, class_2248 block) {
		if (player.field_7503.field_7477) {
			return -1;
		}

		int count = 0;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 invStack = inv.method_5438(i);
			if (invStack.method_7960()) {
				continue;
			}

			class_1792 item = invStack.method_7909();
			if (item == block.method_8389()) {
				count += invStack.method_7947();
			}

			if (item instanceof IBlockProvider) {
				IBlockProvider prov = (IBlockProvider) item;
				int provCount = prov.getBlockCount(player, stack, invStack, block);
				if (provCount == -1) {
					return -1;
				}
				count += provCount;
			}
		}

		return count;
	}

	public void displayRemainderCounter(class_1657 player, class_1799 stack) {
		class_2248 block = getState(stack).method_26204();
		int count = getInventoryItemCount(player, stack, block);
		if (!player.field_6002.field_9236) {
			ItemsRemainingRenderHandler.send(player, new class_1799(block), count);
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	private void setBlock(class_1799 stack, class_2680 state) {
		ItemNBTHelper.setCompound(stack, TAG_BLOCK_NAME, class_2512.method_10686(state));
	}

	@Nonnull
	@Override
	public class_2561 method_7864(@Nonnull class_1799 stack) {
		class_2680 state = getState(stack);
		class_5250 cmp = super.method_7864(stack).method_27661();
		if (!state.method_26215()) {
			cmp.method_27693(" (");
			class_2561 sub = new class_1799(state.method_26204()).method_7964();
			cmp.method_10852(sub.method_27661().method_27692(class_124.field_1060));
			cmp.method_27693(")");
		}
		return cmp;
	}

	public static class_2680 getState(class_1799 stack) {
		return class_2512.method_10681(ItemNBTHelper.getCompound(stack, TAG_BLOCK_NAME, false));
	}

	private void setTarget(class_1799 stack, class_2248 block) {
		ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, class_2378.field_11146.method_10221(block).toString());
	}

	public static class_2248 getTargetState(class_1799 stack) {
		class_2960 id = new class_2960(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
		return class_2378.field_11146.method_10223(id);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack) {
		class_1799 holding = player.method_6047();
		if (holding != stack || !canExchange(stack)) {
			return ImmutableList.of();
		}

		class_2680 state = getState(stack);

		class_239 pos = class_310.method_1551().field_1765;
		if (pos != null && pos.method_17783() == class_239.class_240.field_1332) {
			class_2338 bPos = ((class_3965) pos).method_17777();
			class_2248 target = class_310.method_1551().field_1687.method_8320(bPos).method_26204();
			if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
				bPos = new class_2338(
						ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0),
						ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0),
						ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)
				);
				target = getTargetState(stack);
			}

			if (!player.field_6002.method_22347(bPos)) {
				List<class_2338> coordsList = getTargetPositions(player.field_6002, stack, state, bPos, target);
				coordsList.removeIf(bPos::equals);
				return coordsList;
			}

		}
		return ImmutableList.of();
	}

}
