/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.core.handler.ModSounds;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import java.util.Random;

public class ItemDiviningRod extends class_1792 implements IManaUsingItem, IAvatarWieldable {

	private static final class_2960 avatarOverlay = new class_2960(LibResources.MODEL_AVATAR_DIVINING);

	static final int COST = 3000;

	public ItemDiviningRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 p, @Nonnull class_1268 hand) {
		class_1799 stack = p.method_5998(hand);
		if (ManaItemHandler.instance().requestManaExactForTool(stack, p, COST, true)) {
			if (world.field_9236) {
				int range = IManaProficiencyArmor.hasProficiency(p, stack) ? 20 : 15;
				long seedxor = world.field_9229.nextLong();
				doHighlight(world, p.method_24515(), range, seedxor);
			} else {
				world.method_8465(null, p.method_23317(), p.method_23318(), p.method_23321(), ModSounds.divinationRod, class_3419.field_15248, 1F, 1F);
			}
			return class_1271.method_29237(stack, world.field_9236);
		}

		return class_1271.method_22430(stack);
	}

	private void doHighlight(class_1937 world, class_2338 pos, int range, long seedxor) {
		for (class_2338 pos_ : class_2338.method_10097(pos.method_10069(-range, -range, -range),
				pos.method_10069(range, range, range))) {
			class_2680 state = world.method_8320(pos_);

			class_2248 block = state.method_26204();
			if (false /* todo 1.16-fabric Tags.Blocks.ORES.contains(block) */) {
				Random rand = new Random(class_2378.field_11146.method_10221(block).hashCode() ^ seedxor);
				WispParticleData data = WispParticleData.wisp(0.25F, rand.nextFloat(), rand.nextFloat(), rand.nextFloat(), 8, false);
				world.method_8406(data, pos_.method_10263() + world.field_9229.nextFloat(),
						pos_.method_10264() + world.field_9229.nextFloat(),
						pos_.method_10260() + world.field_9229.nextFloat(),
						0, 0, 0);
			}
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public void onAvatarUpdate(IAvatarTile tile, class_1799 stack) {
		class_2586 te = (class_2586) tile;
		class_1937 world = te.method_10997();
		if (tile.getCurrentMana() >= COST && tile.getElapsedFunctionalTicks() % 200 == 0 && tile.isEnabled()) {
			doHighlight(world, te.method_11016(), 18, te.method_11016().hashCode());
			tile.receiveMana(-COST);
		}
	}

	@Override
	public class_2960 getOverlayResource(IAvatarTile tile, class_1799 stack) {
		return avatarOverlay;
	}
}
