/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.core.helper.PlayerHelper;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class ItemDirtRod extends class_1792 implements IManaUsingItem, IBlockProvider, IAvatarWieldable {

	private static final class_2960 avatarOverlay = new class_2960(LibResources.MODEL_AVATAR_DIRT);

	static final int COST = 75;

	public ItemDirtRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		return place(ctx, class_2246.field_10566, COST, 0.35F, 0.2F, 0.05F);
	}

	public static class_1269 place(class_1838 ctx, class_2248 block, int cost, float r, float g, float b) {
		class_1657 player = ctx.method_8036();
		class_1799 stack = ctx.method_8041();
		class_1937 world = ctx.method_8045();
		class_2350 side = ctx.method_8038();
		class_2338 pos = ctx.method_8037();

		if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, false)) {
			int entities = world.method_18467(class_1309.class,
					new class_238(pos.method_10093(side), pos.method_10093(side).method_10069(1, 1, 1))).size();

			if (entities == 0) {
				class_1269 result = PlayerHelper.substituteUse(ctx, new class_1799(block));

				if (result.method_23665()) {
					ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true);
					SparkleParticleData data = SparkleParticleData.sparkle(1F, r, g, b, 5);
					for (int i = 0; i < 6; i++) {
						world.method_8406(data, pos.method_10263() + side.method_10148() + Math.random(), pos.method_10264() + side.method_10164() + Math.random(), pos.method_10260() + side.method_10165() + Math.random(), 0, 0, 0);
					}
					return result;
				}
			}

			return class_1269.field_5814;
		}

		return class_1269.field_5811;
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public boolean provideBlock(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block, boolean doit) {
		if (block == class_2246.field_10566) {
			return !doit || ManaItemHandler.instance().requestManaExactForTool(requestor, player, COST, true);
		}
		return false;
	}

	@Override
	public int getBlockCount(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block) {
		if (block == class_2246.field_10566) {
			return -1;
		}
		return 0;
	}

	@Override
	public void onAvatarUpdate(IAvatarTile tile, class_1799 stack) {
		class_2586 te = tile.tileEntity();
		class_1937 world = te.method_10997();
		if (!world.field_9236 && tile.getCurrentMana() >= COST && tile.getElapsedFunctionalTicks() % 4 == 0 && world.field_9229.nextInt(8) == 0 && tile.isEnabled()) {
			class_2338 pos = ((class_2586) tile).method_11016().method_10093(tile.getAvatarFacing());
			class_2680 state = world.method_8320(pos);
			if (state.method_26215()) {
				world.method_8501(pos, class_2246.field_10566.method_9564());
				world.method_20290(2001, pos, class_2248.method_9507(class_2246.field_10566.method_9564()));
				tile.receiveMana(-COST);
			}
		}
	}

	@Override
	public class_2960 getOverlayResource(IAvatarTile tile, class_1799 stack) {
		return avatarOverlay;
	}

}
