/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class ItemCobbleRod extends class_1792 implements IManaUsingItem, IBlockProvider {

	static final int COST = 150;

	public ItemCobbleRod(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		return ItemDirtRod.place(ctx, class_2246.field_10445, COST, 0.3F, 0.3F, 0.3F);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public boolean provideBlock(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block, boolean doit) {
		if (block == class_2246.field_10445) {
			return !doit || ManaItemHandler.instance().requestManaExactForTool(requestor, player, COST, true);
		}
		return false;
	}

	@Override
	public int getBlockCount(class_1657 player, class_1799 requestor, class_1799 stack, class_2248 block) {
		if (block == class_2246.field_10445) {
			return -1;
		}
		return 0;
	}

}
