/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.ModItems;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ItemThorRing extends ItemRelicBauble {

	public ItemThorRing(class_1793 props) {
		super(props);
	}

	@Override
	public class_2960 getAdvancement() {
		return prefix("challenge/thor_ring");
	}

	public static class_1799 getThorRing(class_1657 player) {
		return EquipmentHandler.findOrEmpty(ModItems.thorRing, player);
	}
}
