/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

import java.util.List;
import java.util.UUID;

public abstract class ItemRelicBauble extends ItemBauble implements IRelic {

	private final ItemRelic dummy = new ItemRelic(new class_1793()); // Delegate for relic stuff

	public ItemRelicBauble(class_1793 props) {
		super(props);
	}

	public ItemRelic getDummy() {
		return dummy;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
		if (entity instanceof class_1657) {
			dummy.updateRelic(stack, (class_1657) entity);
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addHiddenTooltip(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		super.addHiddenTooltip(stack, world, tooltip, flags);
		dummy.addInformationAfterShift(stack, world, tooltip, flags);
	}

	@Override
	public void bindToUUID(UUID uuid, class_1799 stack) {
		dummy.bindToUUID(uuid, stack);
	}

	@Override
	public UUID getSoulbindUUID(class_1799 stack) {
		return dummy.getSoulbindUUID(stack);
	}

	@Override
	public boolean hasUUID(class_1799 stack) {
		return dummy.hasUUID(stack);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 entity) {
		if (entity instanceof class_1657) {
			class_1657 ePlayer = (class_1657) entity;
			dummy.updateRelic(stack, ePlayer);
			if (dummy.isRightPlayer(ePlayer, stack)) {
				onValidPlayerWornTick(ePlayer);
			}
		}
	}

	public void onValidPlayerWornTick(class_1657 player) {}

	@Override
	public boolean canEquip(class_1799 stack, class_1309 entity) {
		return entity instanceof class_1657 && dummy.isRightPlayer((class_1657) entity, stack);
	}
}
