/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

import java.util.List;
import java.util.UUID;

public class ItemRelic extends class_1792 implements IRelic {

	private static final String TAG_SOULBIND_UUID = "soulbindUUID";

	public ItemRelic(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (!world.field_9236 && entity instanceof class_1657) {
			updateRelic(stack, (class_1657) entity);
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		TooltipHandler.addOnShift(tooltip, () -> addInformationAfterShift(stack, world, tooltip, flags));
	}

	@Environment(EnvType.CLIENT)
	public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		if (!hasUUID(stack)) {
			tooltip.add(new class_2588("botaniamisc.relicUnbound"));
		} else {
			if (!getSoulbindUUID(stack).equals(class_310.method_1551().field_1724.method_5667())) {
				tooltip.add(new class_2588("botaniamisc.notYourSagittarius"));
			} else {
				tooltip.add(new class_2588("botaniamisc.relicSoulbound", class_310.method_1551().field_1724.method_5477()));
			}
		}

		if (stack.method_7909() == ModItems.dice) {
			tooltip.add(new class_2585(""));
			String name = stack.method_7922() + ".poem";
			for (int i = 0; i < 4; i++) {
				tooltip.add(new class_2588(name + i).method_27695(class_124.field_1080, class_124.field_1056));
			}
		}
	}

	public boolean shouldDamageWrongPlayer() {
		return true;
	}

	public void updateRelic(class_1799 stack, class_1657 player) {
		if (stack.method_7960() || !(stack.method_7909() instanceof IRelic)) {
			return;
		}

		boolean rightPlayer = true;

		if (!hasUUID(stack)) {
			bindToUUID(player.method_5667(), stack);
			if (player instanceof class_3222) {
				RelicBindTrigger.INSTANCE.trigger((class_3222) player, stack);
			}
		} else if (!getSoulbindUUID(stack).equals(player.method_5667())) {
			rightPlayer = false;
		}

		if (!rightPlayer && player.field_6012 % 10 == 0 && (!(stack.method_7909() instanceof ItemRelic) || ((ItemRelic) stack.method_7909()).shouldDamageWrongPlayer())) {
			player.method_5643(damageSource(), 2);
		}
	}

	public boolean isRightPlayer(class_1657 player, class_1799 stack) {
		return hasUUID(stack) && getSoulbindUUID(stack).equals(player.method_5667());
	}

	public static class_1282 damageSource() {
		return new class_1282("botania-relic") {};
	}

	@Override
	public void bindToUUID(UUID uuid, class_1799 stack) {
		ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
	}

	@Override
	public UUID getSoulbindUUID(class_1799 stack) {
		if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
			try {
				return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
			} catch (IllegalArgumentException ex) { // Bad UUID in tag
				ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
			}
		}

		return null;
	}

	@Override
	public boolean hasUUID(class_1799 stack) {
		return getSoulbindUUID(stack) != null;
	}
}
