/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.ImmutableList;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemLokiRing extends ItemRelicBauble implements IWireframeCoordinateListProvider, IManaUsingItem {

	private static final String TAG_CURSOR_LIST = "cursorList";
	private static final String TAG_CURSOR_PREFIX = "cursor";
	private static final String TAG_CURSOR_COUNT = "cursorCount";
	private static final String TAG_X_OFFSET = "xOffset";
	private static final String TAG_Y_OFFSET = "yOffset";
	private static final String TAG_Z_OFFSET = "zOffset";
	private static final String TAG_X_ORIGIN = "xOrigin";
	private static final String TAG_Y_ORIGIN = "yOrigin";
	private static final String TAG_Z_ORIGIN = "zOrigin";

	public ItemLokiRing(class_1793 props) {
		super(props);
	}

	public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 lookPos) {
		class_1799 lokiRing = getLokiRing(player);
		if (lokiRing.method_7960() || !player.method_5715()) {
			return class_1269.field_5811;
		}

		class_1799 stack = player.method_5998(hand);
		List<class_2338> cursors = getCursorList(lokiRing);

		if (lookPos.method_17783() != class_239.class_240.field_1332) {
			return class_1269.field_5811;
		}

		class_2338 hit = lookPos.method_17777();
		if (stack.method_7960() && hand == class_1268.field_5808) {
			class_2338 originCoords = getBindingCenter(lokiRing);
			if (!world.field_9236) {
				if (originCoords.method_10264() == -1) {
					// Initiate a new pending list of positions
					setBindingCenter(lokiRing, hit);
					setCursorList(lokiRing, null);
				} else {
					if (originCoords.equals(hit)) {
						// Finalize the pending list of positions
						exitBindingMode(lokiRing);
					} else {
						// Toggle offsets on or off from the pending list of positions
						class_2338 relPos = hit.method_10059(originCoords);

						boolean removed = cursors.remove(relPos);
						if (!removed) {
							cursors.add(relPos);
						}
						setCursorList(lokiRing, cursors);
					}
				}
			}

			return class_1269.field_5812;
		} else {
			int cost = Math.min(cursors.size(), (int) Math.pow(Math.E, cursors.size() * 0.25));
			class_1799 original = stack.method_7972();
			int successes = 0;
			for (class_2338 cursor : cursors) {
				class_2338 pos = hit.method_10081(cursor);
				if (ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, false)) {
					class_243 lookHit = lookPos.method_17784();
					class_243 newHitVec = new class_243(pos.method_10263() + class_3532.method_15385(lookHit.method_10216()), pos.method_10264() + class_3532.method_15385(lookHit.method_10214()), pos.method_10260() + class_3532.method_15385(lookHit.method_10215()));
					class_3965 newHit = new class_3965(newHitVec, lookPos.method_17780(), pos, false);
					class_1838 ctx = new class_1838(player, hand, newHit);

					class_1269 result;
					if (player.method_7337()) {
						result = PlayerHelper.substituteUse(ctx, original.method_7972());
					} else {
						result = stack.method_7981(ctx);
					}

					if (result.method_23665()) {
						ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, true);
						successes++;
					}
				} else {
					break;
				}
			}
			if (successes > 0 && player instanceof class_3222) {
				LokiPlaceTrigger.INSTANCE.trigger((class_3222) player, lokiRing, successes);
			}
			return successes > 0 ? class_1269.field_5812 : class_1269.field_5811;
		}
	}

	public static void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {
		class_1792 item = stack.method_7909();
		class_1799 lokiRing = getLokiRing(player);
		if (lokiRing.method_7960() || player.field_6002.field_9236 || !(item instanceof ISequentialBreaker)) {
			return;
		}

		List<class_2338> cursors = getCursorList(lokiRing);
		ISequentialBreaker breaker = (ISequentialBreaker) item;

		for (class_2338 offset : cursors) {
			class_2338 coords = pos.method_10081(offset);
			class_2680 state = player.field_6002.method_8320(coords);
			breaker.breakOtherBlock(player, stack, coords, pos, side);
			ToolCommons.removeBlockWithDrops(player, stack, player.field_6002, coords,
					s -> s.method_26204() == state.method_26204() && s.method_26207() == state.method_26207());
		}
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 living) {
		setCursorList(stack, null);
	}

	// onUnequipped has itemstack identity issues and doesn't actually fully work, so do this here every tick.
	// This prevents a player from accidentally entering binding mode, then forgetting where the binding center
	// is and thus being unable to exit binding mode.
	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
		super.method_7888(stack, world, entity, slot, held);
		// Curios actually calls this method, but with a negative slot, so we can check if we're in the "real" inventory this way
		if (slot >= 0) {
			exitBindingMode(stack);
		}
	}

	@Override
	@Environment(EnvType.CLIENT)
	public List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack) {
		if (getLokiRing(player) != stack) {
			return ImmutableList.of();
		}

		class_239 lookPos = class_310.method_1551().field_1765;

		if (lookPos != null
				&& lookPos.method_17783() == class_239.class_240.field_1332
				&& !player.field_6002.method_22347(((class_3965) lookPos).method_17777())) {
			List<class_2338> list = getCursorList(stack);
			class_2338 origin = getBindingCenter(stack);

			for (int i = 0; i < list.size(); i++) {
				if (origin.method_10264() != -1) {
					list.set(i, list.get(i).method_10081(origin));
				} else {
					list.set(i, list.get(i).method_10081(((class_3965) lookPos).method_17777()));
				}
			}

			return list;
		}

		return ImmutableList.of();
	}

	@Override
	@Environment(EnvType.CLIENT)
	public class_2338 getSourceWireframe(class_1657 player, class_1799 stack) {
		class_310 mc = class_310.method_1551();
		if (getLokiRing(player) == stack) {
			class_2338 currentBuildCenter = getBindingCenter(stack);
			if (currentBuildCenter.method_10264() != -1) {
				return currentBuildCenter;
			} else if (mc.field_1765 instanceof class_3965
					&& mc.field_1765.method_17783() == class_239.class_240.field_1332
					&& !getCursorList(stack).isEmpty()) {
				return ((class_3965) mc.field_1765).method_17777();
			}
		}

		return null;
	}

	private static class_1799 getLokiRing(class_1657 player) {
		return EquipmentHandler.findOrEmpty(ModItems.lokiRing, player);
	}

	private static class_2338 getBindingCenter(class_1799 stack) {
		int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
		int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
		int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
		return new class_2338(x, y, z);
	}

	private static void exitBindingMode(class_1799 stack) {
		setBindingCenter(stack, new class_2338(0, -1, 0));
	}

	private static void setBindingCenter(class_1799 stack, class_2338 pos) {
		ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.method_10263());
		ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.method_10264());
		ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.method_10260());
	}

	private static List<class_2338> getCursorList(class_1799 stack) {
		class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
		List<class_2338> cursors = new ArrayList<>();

		int count = cmp.method_10550(TAG_CURSOR_COUNT);
		for (int i = 0; i < count; i++) {
			class_2487 cursorCmp = cmp.method_10562(TAG_CURSOR_PREFIX + i);
			int x = cursorCmp.method_10550(TAG_X_OFFSET);
			int y = cursorCmp.method_10550(TAG_Y_OFFSET);
			int z = cursorCmp.method_10550(TAG_Z_OFFSET);
			cursors.add(new class_2338(x, y, z));
		}

		return cursors;
	}

	private static void setCursorList(class_1799 stack, @Nullable List<class_2338> cursors) {
		class_2487 cmp = new class_2487();
		if (cursors != null) {
			int i = 0;
			for (class_2338 cursor : cursors) {
				class_2487 cursorCmp = cursorToCmp(cursor);
				cmp.method_10566(TAG_CURSOR_PREFIX + i, cursorCmp);
				i++;
			}
			cmp.method_10569(TAG_CURSOR_COUNT, i);
		}

		ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
	}

	private static class_2487 cursorToCmp(class_2338 pos) {
		class_2487 cmp = new class_2487();
		cmp.method_10569(TAG_X_OFFSET, pos.method_10263());
		cmp.method_10569(TAG_Y_OFFSET, pos.method_10264());
		cmp.method_10569(TAG_Z_OFFSET, pos.method_10260());
		return cmp;
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public class_2960 getAdvancement() {
		return prefix("challenge/loki_ring");
	}

}
