/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityBabylonWeapon;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import java.util.Random;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemKingKey extends ItemRelic implements IManaUsingItem {

	private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
	private static final String TAG_CHARGING = "charging";

	public static final int WEAPON_TYPES = 12;

	public ItemKingKey(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		player.method_6019(hand);
		class_1799 stack = player.method_5998(hand);
		setCharging(stack, true);
		return class_1271.method_22428(stack);
	}

	@Override
	public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int time) {
		int spawned = getWeaponsSpawned(stack);
		if (spawned == 20) {
			setCharging(stack, false);
			setWeaponsSpawned(stack, 0);
		}
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
		int spawned = getWeaponsSpawned(stack);

		if (count != method_7881(stack) && spawned < 20 && !world.field_9236 && (!(living instanceof class_1657) || ManaItemHandler.instance().requestManaExact(stack, (class_1657) living, 150, true))) {
			Vector3 look = new Vector3(living.method_5720()).multiply(1, 0, 1);

			double playerRot = Math.toRadians(living.field_6031 + 90);
			if (look.x == 0 && look.z == 0) {
				look = new Vector3(Math.cos(playerRot), 0, Math.sin(playerRot));
			}

			look = look.normalize().multiply(-2);

			int div = spawned / 5;
			int mod = spawned % 5;

			Vector3 pl = look.add(Vector3.fromEntityCenter(living)).add(0, 1.6, div * 0.1);

			Random rand = world.field_9229;
			Vector3 axis = look.normalize().crossProduct(new Vector3(-1, 0, -1)).normalize();

			double rot = mod * Math.PI / 4 - Math.PI / 2;

			Vector3 axis1 = axis.multiply(div * 3.5 + 5).rotate(rot, look);
			if (axis1.y < 0) {
				axis1 = axis1.multiply(1, -1, 1);
			}

			Vector3 end = pl.add(axis1);

			EntityBabylonWeapon weapon = new EntityBabylonWeapon(living, world);
			weapon.method_5814(end.x, end.y, end.z);
			weapon.field_6031 = living.field_6031;
			weapon.setVariety(rand.nextInt(WEAPON_TYPES));
			weapon.setDelay(spawned);
			weapon.setRotation(class_3532.method_15393(-living.field_6031 + 180));

			world.method_8649(weapon);
			weapon.method_5783(ModSounds.babylonSpawn, 1F, 1F + world.field_9229.nextFloat() * 3F);
			setWeaponsSpawned(stack, spawned + 1);
		}
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	public static boolean isCharging(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
	}

	public static int getWeaponsSpawned(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
	}

	public static void setCharging(class_1799 stack, boolean charging) {
		ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
	}

	public static void setWeaponsSpawned(class_1799 stack, int count) {
		ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public class_2960 getAdvancement() {
		return prefix("challenge/king_key");
	}

}
