/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.List;
import java.util.Optional;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemFlugelEye extends ItemRelic implements ICoordBoundItem, IManaUsingItem {

	public ItemFlugelEye(class_1793 props) {
		super(props);
	}

	private static final String TAG_TARGET_PREFIX = "target_";

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1657 player = ctx.method_8036();

		if (player != null && player.method_5715()) {
			if (world.field_9236) {
				for (int i = 0; i < 10; i++) {
					float x1 = (float) (pos.method_10263() + Math.random());
					float y1 = pos.method_10264() + 1;
					float z1 = (float) (pos.method_10260() + Math.random());
					WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.5F, (float) Math.random(), (float) Math.random(), (float) Math.random(), 1);
					world.method_8406(data, x1, y1, z1, 0, 0.05F - (float) Math.random() * 0.05F, 0);
				}
			} else {
				class_1799 stack = ctx.method_8041();
				class_2520 nbt = class_2338.field_25064.encodeStart(class_2509.field_11560, pos).get().orThrow();
				ItemNBTHelper.set(stack, TAG_TARGET_PREFIX + world.method_27983().method_29177().toString(), nbt);
				world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1F, 5F);
			}

			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
		if (world.field_9236) {
			float x = (float) (living.method_23317() - Math.random() * living.method_17681());
			float y = (float) (living.method_23318() + Math.random());
			float z = (float) (living.method_23321() - Math.random() * living.method_17681());
			WispParticleData data = WispParticleData.wisp((float) Math.random() * 0.7F, (float) Math.random(), (float) Math.random(), (float) Math.random(), 1);
			world.method_8406(data, x, y, z, 0, 0.05F + (float) Math.random() * 0.05F, 0);
		}
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		player.method_6019(hand);
		return class_1271.method_22428(player.method_5998(hand));
	}

	@Nonnull
	@Override
	public class_1799 method_7861(@Nonnull class_1799 stack, class_1937 world, class_1309 living) {
		String tag = TAG_TARGET_PREFIX + world.method_27983().method_29177().toString();
		class_2520 nbt = ItemNBTHelper.get(stack, tag);
		if (nbt == null) {
			return stack;
		}
		Optional<class_2338> maybeLoc = class_2338.field_25064.parse(class_2509.field_11560, nbt).result();
		if (!maybeLoc.isPresent()) {
			ItemNBTHelper.removeEntry(stack, tag);
			return stack;
		}
		class_2338 loc = maybeLoc.get();
		int x = loc.method_10263();
		int y = loc.method_10264();
		int z = loc.method_10260();

		int cost = (int) (MathHelper.pointDistanceSpace(x + 0.5, y + 0.5, z + 0.5, living.method_23317(), living.method_23318(), living.method_23321()) * 10);

		if (!(living instanceof class_1657) || ManaItemHandler.instance().requestManaExact(stack, (class_1657) living, cost, true)) {
			moveParticlesAndSound(living);
			living.method_5859(x + 0.5, y + 1.5, z + 0.5);
			moveParticlesAndSound(living);
		}

		return stack;
	}

	private static void moveParticlesAndSound(class_1297 entity) {
		PacketBotaniaEffect.sendNearby(entity, PacketBotaniaEffect.EffectType.FLUGEL_EFFECT, entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_5628());
		entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14879, class_3419.field_15248, 1F, 1F);
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 40;
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Nullable
	@Override
	public class_2338 getBinding(class_1937 world, class_1799 stack) {
		String tag = TAG_TARGET_PREFIX + world.method_27983().method_29177().toString();
		class_2520 nbt = ItemNBTHelper.get(stack, tag);
		if (nbt != null) {
			return class_2338.field_25064.parse(class_2509.field_11560, nbt).result()
					.orElse(null);
		}
		return null;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void addInformationAfterShift(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		super.addInformationAfterShift(stack, world, tooltip, flags);

		if (world == null) {
			return;
		}

		class_2338 binding = getBinding(world, stack);
		class_2561 worldText = new class_2585(world.method_27983().method_29177().toString()).method_27692(class_124.field_1060);

		if (binding == null) {
			tooltip.add(new class_2588("botaniamisc.flugelUnbound", worldText).method_27692(class_124.field_1080));
		} else {
			class_2561 bindingText = new class_2585("[").method_27692(class_124.field_1068)
					.method_10852(new class_2585(Integer.toString(binding.method_10263())).method_27692(class_124.field_1065))
					.method_27693(", ")
					.method_10852(new class_2585(Integer.toString(binding.method_10264())).method_27692(class_124.field_1065))
					.method_27693(", ")
					.method_10852(new class_2585(Integer.toString(binding.method_10260())).method_27692(class_124.field_1065))
					.method_27693("]");

			tooltip.add(new class_2588("botaniamisc.flugelBound", bindingText, worldText).method_27692(class_124.field_1080));
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public class_2960 getAdvancement() {
		return prefix("challenge/flugel_eye");
	}

}
