/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

import java.util.ArrayList;
import java.util.List;

public class ItemDice extends ItemRelic {
	public ItemDice(class_1793 props) {
		super(props);
	}

	public static class_1792[] getRelics() {
		return new class_1792[] {
				ModItems.infiniteFruit,
				ModItems.kingKey,
				ModItems.flugelEye,
				ModItems.thorRing,
				ModItems.odinRing,
				ModItems.lokiRing
		};
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);

		if (isRightPlayer(player, stack)) {
			if (world.field_9236) {
				return class_1271.method_22427(stack);
			}

			world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 0.5F, 0.4F / (world.field_9229.nextFloat() * 0.4F + 0.8F));

			List<Integer> possible = new ArrayList<>();
			for (int i = 0; i < 6; i++) {
				if (!hasRelicAlready(player, i)) {
					possible.add(i);
				}
			}

			if (possible.isEmpty()) {
				player.method_9203(new class_2588("botaniamisc.dudDiceRoll", world.field_9229.nextInt(6) + 1).method_27692(class_124.field_1077), class_156.field_25140);
				stack.method_7934(1);
				return class_1271.method_22427(stack);
			} else {
				int relic = possible.get(world.field_9229.nextInt(possible.size()));
				player.method_9203(new class_2588("botaniamisc.diceRoll", relic + 1).method_27692(class_124.field_1077), class_156.field_25140);
				return class_1271.method_22427(new class_1799(getRelics()[relic]));
			}
		}

		return class_1271.method_22430(stack);
	}

	@Override
	public boolean shouldDamageWrongPlayer() {
		return false;
	}

	private boolean hasRelicAlready(class_1657 player, int relic) {
		if (relic < 0 || relic > 6 || !(player instanceof class_3222)) {
			return true;
		}

		class_3222 mpPlayer = (class_3222) player;
		class_1792 item = getRelics()[relic];
		class_2960 advId = ((IRelic) item).getAdvancement();

		if (advId != null) {
			class_161 adv = player.field_6002.method_8503().method_3851().method_12896(advId);
			return adv != null && mpPlayer.method_14236().method_12882(adv).method_740();
		}

		return false;
	}

}
