/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.material;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1295;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.util.*;
import vazkii.botania.common.entity.EntityEnderAirBottle;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemEnderAir extends class_1792 {
	public ItemEnderAir(class_1793 props) {
		super(props);
	}

	public static class_1271<class_1799> onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);

		if (!stack.method_7960() && stack.method_7909() == class_1802.field_8469 && world.method_27983() == class_1937.field_25181) {
			if (!isClearFromDragonBreath(world, player.method_5829().method_1014(3.5D))) {
				return class_1271.method_22430(stack);
			}

			if (!world.field_9236) {
				class_1799 enderAir = new class_1799(ModItems.enderAirBottle);
				player.field_7514.method_7398(world, enderAir);
				stack.method_7934(1);
				world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15254, 0.5F, 1F);
			}

			return class_1271.method_22427(stack);
		}

		return class_1271.method_22430(stack);
	}

	public static boolean isClearFromDragonBreath(class_1937 world, class_238 aabb) {
		List<class_1295> list = world.method_8390(class_1295.class,
				aabb, entity -> entity != null && entity.method_5805()
						&& entity.method_5600().method_10295() == class_2398.field_11216);
		return list.isEmpty();
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (!player.field_7503.field_7477) {
			stack.method_7934(1);
		}

		world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 0.5F, 0.4F / (field_8005.nextFloat() * 0.4F + 0.8F));

		if (!world.field_9236) {
			EntityEnderAirBottle b = new EntityEnderAirBottle(player, world);
			b.method_24919(player, player.field_5965, player.field_6031, 0F, 1.5F, 1F);
			world.method_8649(b);
		}
		return class_1271.method_29237(stack, world.field_9236);
	}
}
