/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;

public class LensWarp extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (entity.field_6002.field_9236 || burst.isFake() || pos.method_17783() != class_239.class_240.field_1332) {
			return dead;
		}

		class_2338 hit = ((class_3965) pos).method_17777();
		class_2248 block = entity.field_6002.method_8320(hit).method_26204();
		if (block == ModBlocks.pistonRelay) {
			BlockPistonRelay.WorldData data = BlockPistonRelay.WorldData.get(entity.field_6002);
			class_2338 dest = data.mapping.get(hit);

			if (dest != null) {
				entity.method_5814(dest.method_10263() + 0.5, dest.method_10264() + 0.5, dest.method_10260() + 0.5);
				burst.setCollidedAt(dest);

				burst.setWarped(true);

				return false;
			}
		}
		return dead;
	}
}
