/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IDirectioned;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.common.core.helper.MathHelper;

public class LensRedirect extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_2338 coords = burst.getBurstSourceBlockPos();
		class_1297 entity = burst.entity();
		if (!entity.field_6002.field_9236 && pos.method_17783() == class_239.class_240.field_1332
				&& coords.method_10264() != -1
				&& !((class_3965) pos).method_17777().equals(coords)) {
			class_2586 tile = entity.field_6002.method_8321(((class_3965) pos).method_17777());
			if (tile instanceof IDirectioned) {
				if (!burst.isFake()) {
					IDirectioned redir = (IDirectioned) tile;
					class_243 tileVec = class_243.method_24953(tile.method_11016());
					class_243 sourceVec = class_243.method_24953(coords);

					class_238 axis;
					class_265 collideShape = entity.field_6002.method_8320(coords).method_26220(entity.field_6002, coords);
					if (collideShape.method_1110()) {
						axis = new class_238(coords, coords.method_10069(1, 1, 1));
					} else {
						axis = collideShape.method_1107().method_996(coords);
					}

					if (!axis.method_1006(sourceVec)) {
						sourceVec = new class_243(axis.field_1323 + (axis.field_1320 - axis.field_1323) / 2, axis.field_1322 + (axis.field_1325 - axis.field_1322) / 2, axis.field_1321 + (axis.field_1324 - axis.field_1321) / 2);
					}

					class_243 diffVec = sourceVec.method_1020(tileVec);
					class_243 diffVec2D = new class_243(diffVec.field_1352, diffVec.field_1350, 0);
					class_243 rotVec = new class_243(0, 1, 0);
					double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;

					if (sourceVec.field_1352 < tileVec.field_1352) {
						angle = -angle;
					}

					redir.setRotationX((float) angle + 90F);

					rotVec = new class_243(diffVec.field_1352, 0, diffVec.field_1350);
					angle = MathHelper.angleBetween(diffVec, rotVec) * 180F / Math.PI;
					if (sourceVec.field_1351 < tileVec.field_1351) {
						angle = -angle;
					}
					redir.setRotationY((float) angle);

					redir.commitRedirection();
					if (redir instanceof IThrottledPacket) {
						((IThrottledPacket) redir).markDispatchable();
					}
				}
			}
		}

		return dead;
	}

}
