/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaBlock;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;

public class LensMine extends Lens {
	@Override
	public boolean collideBurst(IManaBurst burst, class_239 rtr, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_1937 world = entity.field_6002;

		if (world.field_9236 || rtr.method_17783() != class_239.class_240.field_1332) {
			return false;
		}

		class_2338 collidePos = ((class_3965) rtr).method_17777();
		class_2680 state = world.method_8320(collidePos);
		class_2248 block = state.method_26204();

		class_1799 composite = ((ItemLens) stack.method_7909()).getCompositeLens(stack);
		boolean warp = !composite.method_7960() && composite.method_7909() == ModItems.lensWarp;

		if (warp && (block == ModBlocks.pistonRelay || block == class_2246.field_10560 || block == class_2246.field_10008 || block == class_2246.field_10379)) {
			return false;
		}

		int harvestLevel = ConfigHandler.COMMON.harvestLevelBore.getValue();

		class_2586 tile = world.method_8321(collidePos);

		float hardness = state.method_26214(world, collidePos);
		int neededHarvestLevel = -1 /* todo 1.16-fabric block.getHarvestLevel(state) */;
		int mana = burst.getMana();

		class_2338 source = burst.getBurstSourceBlockPos();
		if (!source.equals(collidePos)
				&& !(tile instanceof IManaBlock)
				&& neededHarvestLevel <= harvestLevel
				&& hardness != -1 && hardness < 50F
				&& (burst.isFake() || mana >= 24)) {
			if (!burst.hasAlreadyCollidedAt(collidePos)) {
				if (!burst.isFake()) {
					List<class_1799> items = class_2248.method_9562(state, (class_3218) world, collidePos, tile);

					world.method_8650(collidePos, false);
					if (ConfigHandler.COMMON.blockBreakParticles.getValue()) {
						world.method_20290(2001, collidePos, class_2248.method_9507(state));
					}

					boolean offBounds = source.method_10264() < 0;
					boolean doWarp = warp && !offBounds;
					class_2338 dropCoord = doWarp ? source : collidePos;

					for (class_1799 stack_ : items) {
						class_2248.method_9577(world, dropCoord, stack_);
					}

					burst.setMana(mana - 24);
				}
			}

			dead = false;
		}

		return dead;
	}

}
