/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaReceiver;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;

public class LensMagnet extends Lens {

	@Override
	public void updateBurst(IManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_2338 basePos = entity.method_24515();
		boolean magnetized = burst.getMagnetizedPos() != null;
		int range = 3;

		class_2338 source = burst.getBurstSourceBlockPos();
		final boolean sourceless = source.method_10264() == -1;

		Predicate<class_2586> predicate = tile -> tile instanceof IManaReceiver
				&& (sourceless || tile.method_11016().method_10262(source) > 9)
				&& ((IManaReceiver) tile).canReceiveManaFromBursts()
				&& !((IManaReceiver) tile).isFull();

		class_2586 tile = null;
		if (magnetized) {
			tile = entity.field_6002.method_8321(burst.getMagnetizedPos());
			if (!predicate.test(tile)) {
				tile = null;
				burst.setMagnetizePos(null);
				magnetized = false;
			}
		}

		if (!magnetized) {
			for (class_2338 pos : class_2338.method_10097(basePos.method_10069(-range, -range, -range),
					basePos.method_10069(range, range, range))) {
				tile = entity.field_6002.method_8321(pos);
				if (predicate.test(tile)) {
					break;
				}
				tile = null;
			}
		}

		if (tile == null) {
			return;
		}

		class_243 burstVec = entity.method_19538();
		class_243 tileVec = class_243.method_24953(tile.method_11016()).method_1031(0, -0.1, 0);
		class_243 motionVec = entity.method_18798();

		class_243 normalMotionVec = motionVec.method_1029();
		class_243 magnetVec = tileVec.method_1020(burstVec).method_1029();
		class_243 differenceVec = normalMotionVec.method_1020(magnetVec).method_1021(motionVec.method_1033() * 0.1);

		class_243 finalMotionVec = motionVec.method_1020(differenceVec);
		if (!magnetized) {
			finalMotionVec = finalMotionVec.method_1021(0.75);
			burst.setMagnetizePos(tile.method_11016());
		}

		burst.setBurstMotion(finalMotionVec.field_1352, finalMotionVec.field_1351, finalMotionVec.field_1350);
	}

}
