/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;

public class LensLight extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_1297 entity = burst.entity();
		class_2338 coords = burst.getBurstSourceBlockPos();
		if (!entity.field_6002.field_9236 && pos.method_17783() == class_239.class_240.field_1332 && !burst.isFake() && !isManaBlock) {
			class_3965 rtr = (class_3965) pos;
			if (!coords.equals(rtr.method_17777())) {
				class_2338 neighborPos = rtr.method_17777().method_10093(rtr.method_17780());

				class_2248 blockAt = entity.field_6002.method_8320(rtr.method_17777()).method_26204();
				class_2680 neighbor = entity.field_6002.method_8320(neighborPos);

				if (blockAt == ModBlocks.manaFlame) {
					entity.field_6002.method_8501(rtr.method_17777(), class_2246.field_10124.method_9564());
				} else if (neighbor.method_26215() || neighbor.method_26207().method_15800()) {
					entity.field_6002.method_8501(neighborPos, ModBlocks.manaFlame.method_9564());
					class_2586 tile = entity.field_6002.method_8321(neighborPos);

					if (tile instanceof TileManaFlame) {
						((TileManaFlame) tile).setColor(burst.getColor());
					}
				}
			}
		}

		return dead;
	}

}
