/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import com.google.common.base.Predicates;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.item.ModItems;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_238;

public class LensInfluence extends Lens {

	@Override
	public void updateBurst(IManaBurst burst, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (!burst.isFake()) {
			double range = 3.5;
			class_238 bounds = new class_238(entity.method_23317() - range, entity.method_23318() - range, entity.method_23321() - range, entity.method_23317() + range, entity.method_23318() + range, entity.method_23321() + range);
			List<class_1297> movables = entity.field_6002.method_18467(class_1542.class, bounds);
			movables.addAll(entity.field_6002.method_18467(class_1303.class, bounds));
			movables.addAll(entity.field_6002.method_18467(class_1665.class, bounds));
			movables.addAll(entity.field_6002.method_18467(class_1540.class, bounds));
			movables.addAll(entity.field_6002.method_8390(class_1682.class, bounds, Predicates.instanceOf(IManaBurst.class)));

			for (class_1297 movable : movables) {
				if (movable == burst) {
					continue;
				}

				if (movable instanceof IManaBurst) {
					IManaBurst otherBurst = (IManaBurst) movable;
					class_1799 lens = otherBurst.getSourceLens();
					if (!lens.method_7960() && lens.method_7909() == ModItems.lensInfluence) {
						continue;
					}

					((IManaBurst) movable).setBurstMotion(entity.method_18798().method_10216(),
							entity.method_18798().method_10214(), entity.method_18798().method_10215());
				} else {
					movable.method_18799(entity.method_18798());
				}
			}
		}
	}

}
