/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ColorHelper;

public class LensFlare extends Lens {

	@Override
	public boolean allowBurstShooting(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		return false;
	}

	@Override
	public void onControlledSpreaderTick(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		if (!redstone) {
			emitParticles(stack, spreader, redstone);
		}
	}

	@Override
	public void onControlledSpreaderPulse(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		emitParticles(stack, spreader, redstone);
	}

	private void emitParticles(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		float rotationYaw = -(spreader.getRotationX() + 90F);
		float rotationPitch = spreader.getRotationY();

		// Lots of EntityThrowable copypasta
		float f = 0.3F;
		float mx = (float) (class_3532.method_15374(rotationYaw / 180.0F * (float) Math.PI) * class_3532.method_15362(rotationPitch / 180.0F * (float) Math.PI) * f / 2D);
		float mz = (float) (-(class_3532.method_15362(rotationYaw / 180.0F * (float) Math.PI) * class_3532.method_15362(rotationPitch / 180.0F * (float) Math.PI) * f) / 2D);
		float my = (float) (class_3532.method_15374(rotationPitch / 180.0F * (float) Math.PI) * f / 2D);

		int storedColor = ItemLens.getStoredColor(stack);
		int hex = -1;

		class_2586 tile = spreader.tileEntity();
		if (storedColor == 16) {
			hex = class_3532.method_15369(tile.method_10997().method_8510() * 2 % 360 / 360F, 1F, 1F);
		} else if (storedColor >= 0) {
			hex = ColorHelper.getColorValue(class_1767.method_7791(storedColor));
		}

		float r = ((hex & 0xFF0000) >> 16) / 255F;
		float g = ((hex & 0xFF00) >> 8) / 255F;
		float b = (hex & 0xFF) / 255F;

		WispParticleData data = WispParticleData.wisp(0.4F, r, g, b);
		tile.method_10997().method_8406(data, tile.method_11016().method_10263() + 0.5, tile.method_11016().method_10264() + 0.5, tile.method_11016().method_10260() + 0.5, mx, my, mz);
	}

}
