/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class LensFirework extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (!entity.field_6002.field_9236 && !burst.isFake()) {
			class_2338 coords = burst.getBurstSourceBlockPos();
			if (pos.method_17783() == class_239.class_240.field_1332
					&& !isManaBlock
					&& !((class_3965) pos).method_17777().equals(coords)) {
				class_1799 fireworkStack = generateFirework(burst.getColor());

				class_1671 rocket = new class_1671(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), fireworkStack);
				entity.field_6002.method_8649(rocket);
			}
		} else {
			dead = false;
		}

		return dead;
	}

	private class_1799 generateFirework(int color) {
		class_1799 stack = new class_1799(class_1802.field_8639);
		class_2487 explosion = new class_2487();
		explosion.method_10539("Colors", new int[] { color });

		int type = 1;
		double rand = Math.random();
		if (rand > 0.25) {
			if (rand > 0.9) {
				type = 2;
			} else {
				type = 0;
			}
		}

		explosion.method_10569("Type", type);

		if (Math.random() < 0.05) {
			if (Math.random() < 0.5) {
				explosion.method_10556("Flicker", true);
			} else {
				explosion.method_10556("Trail", true);
			}
		}

		ItemNBTHelper.setCompound(stack, "Explosion", explosion);

		class_2487 fireworks = new class_2487();
		fireworks.method_10569("Flight", (int) (Math.random() * 3 + 2));

		class_2499 explosions = new class_2499();
		explosions.add(explosion);
		fireworks.method_10566("Explosions", explosions);

		ItemNBTHelper.setCompound(stack, "Fireworks", fireworks);

		return stack;
	}

}
