/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileIncensePlate;

public class LensFire extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 rtr, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_2338 coords = burst.getBurstSourceBlockPos();
		class_1297 entity = burst.entity();

		if (!entity.field_6002.field_9236 && rtr.method_17783() == class_239.class_240.field_1332
				&& !burst.isFake() && !isManaBlock) {
			class_3965 brtr = (class_3965) rtr;
			class_2338 pos = brtr.method_17777();
			if (!coords.equals(pos)) {
				class_2350 dir = brtr.method_17780();

				class_2338 offPos = pos.method_10093(dir);

				class_2248 blockAt = entity.field_6002.method_8320(pos).method_26204();
				class_2680 stateAtOffset = entity.field_6002.method_8320(offPos);
				class_2248 blockAtOffset = stateAtOffset.method_26204();

				if (blockAt == class_2246.field_10316) {
					entity.field_6002.method_8501(pos, class_2246.field_10124.method_9564());
				}
				if (blockAtOffset == class_2246.field_10316) {
					entity.field_6002.method_8501(offPos, class_2246.field_10124.method_9564());
				} else if (blockAt == ModBlocks.incensePlate) {
					TileIncensePlate plate = (TileIncensePlate) entity.field_6002.method_8321(pos);
					plate.ignite();
					VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
				} else if (stateAtOffset.method_26215()) {
					entity.field_6002.method_8501(offPos, class_2246.field_10036.method_9564());
				}
			}
		}

		return dead;
	}

}
