/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.core.helper.Vector3;

public class LensBounce extends Lens {

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		class_1682 entity = burst.entity();
		if (!isManaBlock && pos.method_17783() == class_239.class_240.field_1332) {
			class_2338 coords = burst.getBurstSourceBlockPos();
			class_3965 rtr = (class_3965) pos;
			if (!coords.equals(rtr.method_17777())) {
				Vector3 currentMovementVec = new Vector3(entity.method_18798());
				class_2350 dir = rtr.method_17780();
				Vector3 normalVector = new Vector3(dir.method_10148(), dir.method_10164(), dir.method_10165()).normalize();
				Vector3 movementVec = normalVector.multiply(-2 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);

				burst.setBurstMotion(movementVec.x, movementVec.y, movementVec.z);
				dead = false;
			}
		}

		return dead;
	}

}
