/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.*;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

import java.util.List;

public class ItemLens extends class_1792 implements ILensControl, ICompositableLens, ITinyPlanetExcempt {
	public static final int PROP_NONE = 0,
			PROP_POWER = 1,
			PROP_ORIENTATION = 1 << 1,
			PROP_TOUCH = 1 << 2,
			PROP_INTERACTION = 1 << 3,
			PROP_DAMAGE = 1 << 4,
			PROP_CONTROL = 1 << 5;

	private static final String TAG_COLOR = "color";
	private static final String TAG_COMPOSITE_LENS = "compositeLens";

	private final Lens lens;
	private final int props;

	public ItemLens(class_1792.class_1793 builder, Lens lens, int props) {
		super(builder);
		this.lens = lens;
		this.props = props;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		int storedColor = getStoredColor(stack);
		if (storedColor != -1) {
			class_2588 colorName = new class_2588(storedColor == 16 ? "botania.color.rainbow" : "color.minecraft." + class_1767.method_7791(storedColor));
			class_5251 realColor = class_5251.method_27717(getLensColor(stack));
			stacks.add(new class_2588("botaniamisc.color", colorName).method_27694(s -> s.method_27703(realColor)));
		}

		if (lens instanceof LensStorm) {
			stacks.add(new class_2588("botaniamisc.creative").method_27692(class_124.field_1080));
		}
	}

	@Nonnull
	@Override
	public class_2561 method_7864(@Nonnull class_1799 stack) {
		class_1799 compositeLens = getCompositeLens(stack);
		if (compositeLens.method_7960()) {
			return super.method_7864(stack);
		}
		String shortKeyA = stack.method_7922() + ".short";
		String shortKeyB = compositeLens.method_7922() + ".short";
		return new class_2588("item.botania.composite_lens", new class_2588(shortKeyA), new class_2588(shortKeyB));
	}

	@Override
	public void apply(class_1799 stack, BurstProperties props) {
		int storedColor = getStoredColor(stack);
		if (storedColor != -1) {
			props.color = getLensColor(stack);
		}

		getLens(stack).apply(stack, props);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof ILens) {
			((ILens) compositeLens.method_7909()).apply(compositeLens, props);
		}
	}

	@Override
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack) {
		dead = getLens(stack).collideBurst(burst, pos, isManaBlock, dead, stack);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof ILens) {
			dead = ((ILens) compositeLens.method_7909()).collideBurst(burst, pos, isManaBlock, dead, compositeLens);
		}

		return dead;
	}

	@Override
	public void updateBurst(IManaBurst burst, class_1799 stack) {
		int storedColor = getStoredColor(stack);

		if (storedColor == 16 && burst.entity().field_6002.field_9236) {
			burst.setColor(getLensColor(stack));
		}

		getLens(stack).updateBurst(burst, stack);

		class_1799 compositeLens = getCompositeLens(stack);
		if (!compositeLens.method_7960() && compositeLens.method_7909() instanceof ILens) {
			((ILens) compositeLens.method_7909()).updateBurst(burst, compositeLens);
		}
	}

	@Override
	public int getLensColor(class_1799 stack) {
		int storedColor = getStoredColor(stack);

		if (storedColor == -1) {
			return 0xFFFFFF;
		}

		if (storedColor == 16) {
			return class_3532.method_15369(Botania.proxy.getWorldElapsedTicks() * 2 % 360 / 360F, 1F, 1F);
		}

		return ColorHelper.getColorValue(class_1767.method_7791(storedColor));
	}

	public static int getStoredColor(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
	}

	public static void setLensColor(class_1799 stack, int color) {
		ItemNBTHelper.setInt(stack, TAG_COLOR, color);
	}

	@Override
	public boolean doParticles(IManaBurst burst, class_1799 stack) {
		return true;
	}

	public static boolean isBlacklisted(class_1799 lens1, class_1799 lens2) {
		ICompositableLens item1 = (ICompositableLens) lens1.method_7909();
		ICompositableLens item2 = (ICompositableLens) lens2.method_7909();
		return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
	}

	public static Lens getLens(class_1799 stack) {
		if (stack.method_7909() instanceof ItemLens) {
			return ((ItemLens) stack.method_7909()).lens;
		} else {
			return new Lens();
		}
	}

	@Override
	public boolean canCombineLenses(class_1799 sourceLens, class_1799 compositeLens) {
		ICompositableLens sourceItem = (ICompositableLens) sourceLens.method_7909();
		ICompositableLens compositeItem = (ICompositableLens) compositeLens.method_7909();
		if (sourceItem == compositeItem) {
			return false;
		}

		if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
			return false;
		}

		if (isBlacklisted(sourceLens, compositeLens)) {
			return false;
		}

		return true;
	}

	@Override
	public class_1799 getCompositeLens(class_1799 stack) {
		class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, true);
		if (cmp == null) {
			return class_1799.field_8037;
		} else {
			return class_1799.method_7915(cmp);
		}
	}

	@Override
	public class_1799 setCompositeLens(class_1799 sourceLens, class_1799 compositeLens) {
		if (!compositeLens.method_7960()) {
			class_2487 cmp = compositeLens.method_7953(new class_2487());
			ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
		}
		return sourceLens;
	}

	@Override
	public int getManaToTransfer(IManaBurst burst, class_1799 stack, IManaReceiver receiver) {
		return getLens(stack).getManaToTransfer(burst, stack, receiver);
	}

	@Override
	public boolean shouldPull(class_1799 stack) {
		return stack.method_7909() != ModItems.lensStorm;
	}

	@Override
	public boolean isControlLens(class_1799 stack) {
		return (getProps(stack) & PROP_CONTROL) != 0;
	}

	@Override
	public boolean allowBurstShooting(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		return getLens(stack).allowBurstShooting(stack, spreader, redstone);
	}

	@Override
	public void onControlledSpreaderTick(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
	}

	@Override
	public void onControlledSpreaderPulse(class_1799 stack, IManaSpreader spreader, boolean redstone) {
		getLens(stack).onControlledSpreaderPulse(stack, spreader, redstone);
	}

	@Override
	public int getProps(class_1799 stack) {
		return props;
	}

	@Override
	public boolean isCombinable(class_1799 stack) {
		return stack.method_7909() != ModItems.lensNormal;
	}

}
