/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.item.*;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.mixin.AccessorHoeItem;

import javax.annotation.Nonnull;

import java.util.function.Consumer;

public class ItemManasteelShovel extends class_1821 implements IManaUsingItem, ISortableTool {

	private static final int MANA_PER_DAMAGE = 60;

	public ItemManasteelShovel(class_1793 props) {
		this(BotaniaAPI.instance().getManasteelItemTier(), props);
	}

	public ItemManasteelShovel(class_1832 mat, class_1793 props) {
		super(mat, 1.5F, -3.0F, props);
	}

	public static <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		int manaPerDamage = ((ItemManasteelShovel) stack.method_7909()).getManaPerDamage();
		return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPerDamage);
	}

	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1269 pathResult = super.method_7884(ctx);
		if (pathResult.method_23665()) {
			return pathResult;
		}

		class_1799 stack = ctx.method_8041();
		class_1657 player = ctx.method_8036();
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();

		if (player == null || !player.method_7343(pos, ctx.method_8038(), stack)) {
			return class_1269.field_5811;
		}

		class_2248 block = world.method_8320(pos).method_26204();
		class_2680 converted = AccessorHoeItem.getConversions().get(block);
		if (converted == null) {
			return class_1269.field_5811;
		}

		if (ctx.method_8038() != class_2350.field_11033 && world.method_8320(pos.method_10084()).method_26215()) {
			world.method_8396(null, pos, converted.method_26231().method_10594(),
					class_3419.field_15245,
					(converted.method_26231().method_10597() + 1.0F) / 2.0F,
					converted.method_26231().method_10599() * 0.8F);

			if (world.field_9236) {
				return class_1269.field_5812;
			} else {
				world.method_8501(pos, converted);
				stack.method_7956(1, player, p -> p.method_20236(ctx.method_20287()));
				return class_1269.field_5812;
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 player, int slot, boolean selected) {
		if (!world.field_9236 && player instanceof class_1657 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (class_1657) player, getManaPerDamage() * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public int getSortingPriority(class_1799 stack, class_2680 state) {
		return ToolCommons.getToolPriority(stack);
	}
}
