/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class ItemManasteelAxe extends class_1743 implements IManaUsingItem, ISortableTool {

	private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");

	private static final int MANA_PER_DAMAGE = 60;

	public ItemManasteelAxe(class_1793 props) {
		this(BotaniaAPI.instance().getManasteelItemTier(), props);
	}

	public ItemManasteelAxe(class_1832 mat, class_1793 props) {
		super(mat, 6F, -3.1F, props);
	}

	public static <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		int manaPerDamage = ((ItemManasteelAxe) stack.method_7909()).getManaPerDamage();
		return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPerDamage);
	}

	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@Nonnull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1657 player = ctx.method_8036();
		if (player != null) {
			for (int i = 0; i < player.field_7514.method_5439(); i++) {
				class_1799 stackAt = player.field_7514.method_5438(i);
				if (!stackAt.method_7960() && SAPLING_PATTERN.matcher(stackAt.method_7909().method_7876()).find()) {
					class_1799 displayStack = stackAt.method_7972();
					if (PlayerHelper.substituteUse(ctx, stackAt).method_23665()) {
						if (!ctx.method_8045().field_9236) {
							ItemsRemainingRenderHandler.send(player, displayStack, SAPLING_PATTERN);
						}
						return class_1269.field_5812;
					}
				}
			}
		}

		return super.method_7884(ctx);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 player, int slot, boolean selected) {
		if (!world.field_9236 && player instanceof class_1657 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (class_1657) player, getManaPerDamage() * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

	@Override
	public int getSortingPriority(class_1799 stack, class_2680 state) {
		return ToolCommons.getToolPriority(stack);
	}
}
