/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_3614;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelShovel;

public class ItemElementiumShovel extends ItemManasteelShovel {

	public ItemElementiumShovel(class_1793 props) {
		super(BotaniaAPI.instance().getElementiumItemTier(), props);
	}

	public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
		class_1937 world = player.field_6002;
		class_3614 mat = world.method_8320(pos).method_26207();
		if (!ToolCommons.materialsShovel.contains(mat)) {
			return false;
		}

		class_2248 blk = world.method_8320(pos).method_26204();
		if (blk instanceof class_2346) {
			ToolCommons.removeBlocksInIteration(player, stack, world, pos, new class_2382(0, -12, 0),
					new class_2382(1, 12, 1),
					state -> state.method_26204() == blk);
		}

		return false;
	}

}
