/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelShears;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_5147;
import java.util.List;
import java.util.function.Predicate;

public class ItemElementiumShears extends ItemManasteelShears {

	public ItemElementiumShears(class_1793 props) {
		super(props);
	}

	@Nonnull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@Nonnull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
		player.method_6019(hand);
		return class_1271.method_22428(player.method_5998(hand));
	}

	@Override
	public void method_7852(class_1937 world, @Nonnull class_1309 living, @Nonnull class_1799 stack, int count) {
		if (world.field_9236) {
			return;
		}

		if (count != method_7881(stack) && count % 5 == 0) {
			int range = 12;
			Predicate<class_1297> shearablePred = e -> e instanceof class_5147;
			List<class_1297> shearable = world.method_8390(class_1297.class, new class_238(living.method_23317() - range, living.method_23318() - range, living.method_23321() - range, living.method_23317() + range, living.method_23318() + range, living.method_23321() + range), shearablePred);
			if (shearable.size() > 0) {
				for (class_1297 entity : shearable) {
					if (entity instanceof class_5147 && ((class_5147) entity).method_27072()) {
						((class_5147) entity).method_6636(living.method_5634());
						stack.method_7956(1, living, l -> l.method_20236(l.method_6058()));
						break;
					}
				}
			}
		}
	}

	@Override
	public boolean method_7878(class_1799 toRepair, @Nonnull class_1799 repairBy) {
		return repairBy.method_7909() == ModItems.elementium || super.method_7878(toRepair, repairBy);
	}

}
