/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.lib.ModTags;

public class ItemElementiumPick extends ItemManasteelPick {

	public ItemElementiumPick(class_1793 props) {
		super(BotaniaAPI.instance().getElementiumItemTier(), props, -2.8F);
	}

	public static boolean shouldFilterOut(class_1297 e, class_1799 tool, class_1799 drop) {
		if (!tool.method_7960() && (tool.method_7909() == ModItems.elementiumPick
				|| tool.method_7909() == ModItems.terraPick && ItemTerraPick.isTipped(tool))) {
			return !drop.method_7960() && (isDisposable(drop) || isSemiDisposable(drop) && !e.method_5715());
		}
		return false;
	}

	public static boolean isDisposable(class_2248 block) {
		return ModTags.Items.DISPOSABLE.method_15141(block.method_8389());
	}

	private static boolean isDisposable(class_1799 stack) {
		if (stack.method_7960()) {
			return false;
		}

		return ModTags.Items.DISPOSABLE.method_15141(stack.method_7909());
	}

	private static boolean isSemiDisposable(class_1799 stack) {
		return ModTags.Items.SEMI_DISPOSABLE.method_15141(stack.method_7909());
	}
}
