/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.bow;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;

public class ItemCrystalBow extends ItemLivingwoodBow {

	private static final int ARROW_COST = 200;

	public ItemCrystalBow(class_1793 builder) {
		super(builder);
	}

	@Override
	public float chargeVelocityMultiplier() {
		return 2F;
	}

	@Override
	boolean canFire(class_1799 stack, class_1657 player) {
		boolean infinity = class_1890.method_8225(class_1893.field_9125, stack) > 0;
		return player.field_7503.field_7477 || ManaItemHandler.instance().requestManaExactForTool(stack, player, ARROW_COST / (infinity ? 2 : 1), false);
	}

	@Override
	void onFire(class_1799 stack, class_1309 living, boolean infinity, class_1665 arrow) {
		arrow.field_7572 = class_1665.class_1666.field_7594;
	}

	public static <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		boolean infinity = class_1890.method_8225(class_1893.field_9125, stack) > 0;
		return ToolCommons.damageItemIfPossible(stack, amount, entity, ARROW_COST / (infinity ? 2 : 1));
	}
}
