/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;

public class ItemThunderSword extends ItemManasteelSword {

	private static final String TAG_LIGHTNING_SEED = "lightningSeed";

	public ItemThunderSword(class_1793 props) {
		super(BotaniaAPI.instance().getTerrasteelItemTier(), 3, -1.5F, props);
	}

	@Override
	public boolean method_7873(class_1799 stack, class_1309 entity, @Nonnull class_1309 attacker) {
		if (!(entity instanceof class_1657) && entity != null) {
			double range = 8;
			List<class_1309> alreadyTargetedEntities = new ArrayList<>();
			int dmg = 5;
			long lightningSeed = ItemNBTHelper.getLong(stack, TAG_LIGHTNING_SEED, 0);

			Predicate<class_1297> selector = e -> e instanceof class_1309 && e instanceof class_1569 && !(e instanceof class_1657) && !alreadyTargetedEntities.contains(e);

			Random rand = new Random(lightningSeed);
			class_1309 lightningSource = entity;
			int hops = entity.field_6002.method_8546() ? 10 : 4;
			for (int i = 0; i < hops; i++) {
				List<class_1297> entities = entity.field_6002.method_8333(lightningSource, new class_238(lightningSource.method_23317() - range, lightningSource.method_23318() - range, lightningSource.method_23321() - range, lightningSource.method_23317() + range, lightningSource.method_23318() + range, lightningSource.method_23321() + range), selector::test);
				if (entities.isEmpty()) {
					break;
				}

				class_1309 target = (class_1309) entities.get(rand.nextInt(entities.size()));
				if (attacker instanceof class_1657) {
					target.method_5643(class_1282.method_5532((class_1657) attacker), dmg);
				} else {
					target.method_5643(class_1282.method_5511(attacker), dmg);
				}

				Botania.proxy.lightningFX(Vector3.fromEntityCenter(lightningSource), Vector3.fromEntityCenter(target), 1, 0x0179C4, 0xAADFFF);

				alreadyTargetedEntities.add(target);
				lightningSource = target;
				dmg--;
			}

			if (!entity.field_6002.field_9236) {
				ItemNBTHelper.setLong(stack, TAG_LIGHTNING_SEED, entity.field_6002.field_9229.nextLong());
			}
		}

		return super.method_7873(stack, entity, attacker);
	}

}
