/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool;

import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;

import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;

public class ItemGlassPick extends ItemManasteelPick {
	private static final String TAG_SILK_HACK = "botania:silk_hack";
	private static final int MANA_PER_DAMAGE = 160;
	private static final class_1832 MATERIAL = new class_1832() {
		@Override
		public int method_8025() {
			return 125;
		}

		@Override
		public float method_8027() {
			return 4.8F;
		}

		@Override
		public float method_8028() {
			return 0;
		}

		@Override
		public int method_8024() {
			return 0;
		}

		@Override
		public int method_8026() {
			return 10;
		}

		@Override
		public class_1856 method_8023() {
			return class_1856.method_8091(class_2246.field_10033);
		}
	};

	public ItemGlassPick(class_1793 props) {
		super(MATERIAL, props, -1);
	}

	/*
	* No way to modify the loot context so we're gonna go braindead hack workaround here:
	* - When block starting to break, if the tool doesn't have silktouch already, add it and add a "temp silk touch" flag
	* - Every tick, if the "temp silk touch" flag is present, remove it and remove any silk touch enchants from the stack
	*/

	public boolean onBlockStartBreak(class_1799 itemstack, class_2338 pos, class_1657 player) {
		class_2680 state = player.field_6002.method_8320(pos);
		boolean hasSilk = class_1890.method_8225(class_1893.field_9099, itemstack) > 0;
		if (hasSilk || !isGlass(state)) {
			return false;
		}

		itemstack.method_7978(class_1893.field_9099, 1);
		itemstack.method_7969().method_10556(TAG_SILK_HACK, true);

		return false;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 player, int slot, boolean selected) {
		super.method_7888(stack, world, player, slot, selected);
		if (stack.method_7948().method_10577(TAG_SILK_HACK)) {
			stack.method_7969().method_10551(TAG_SILK_HACK);
			Map<class_1887, Integer> ench = class_1890.method_8222(stack);
			ench.remove(class_1893.field_9099);
			class_1890.method_8214(ench, stack);
		}
	}

	private boolean isGlass(class_2680 state) {
		return state.method_26207() == class_3614.field_15942; // todo 1.16-fabric || Tags.Blocks.GLASS.contains(state.getBlock());
	}

	@Override
	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@Override
	public int getSortingPriority(class_1799 stack, class_2680 state) {
		return isGlass(state) ? Integer.MAX_VALUE : 0;
	}

}
