/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.core.handler.EquipmentHandler;

import java.util.ArrayList;
import java.util.List;

public class ItemTravelBelt extends ItemBauble implements IManaUsingItem {

	private static final class_2960 texture = new class_2960(LibResources.MODEL_TRAVEL_BELT);
	@Environment(EnvType.CLIENT)
	private static class_572<class_1309> model;

	private static final int COST = 1;
	private static final int COST_INTERVAL = 10;

	public static final List<String> playersWithStepup = new ArrayList<>();

	public final float speed;
	public final float jump;
	public final float fallBuffer;

	public ItemTravelBelt(class_1793 props) {
		this(props, 0.035F, 0.2F, 2F);
	}

	public static float onPlayerFall(class_1657 player, float dist) {
		class_1799 stack = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, player);
		if (!stack.method_7960()) {
			return Math.max(0, dist - ((ItemTravelBelt) stack.method_7909()).fallBuffer);
		}
		return dist;
	}

	public ItemTravelBelt(class_1793 props, float speed, float jump, float fallBuffer) {
		super(props);
		this.speed = speed;
		this.jump = jump;
		this.fallBuffer = fallBuffer;
	}

	public static void updatePlayerStepStatus(class_1657 player) {
		class_1799 belt = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, player);
		String s = playerStr(player);

		if (playersWithStepup.contains(s)) {
			if (shouldPlayerHaveStepup(player)) {
				ItemTravelBelt beltItem = (ItemTravelBelt) belt.method_7909();

				if (player.field_6002.field_9236) {
					if ((player.method_24828() || player.field_7503.field_7479) && player.field_6250 > 0F && !player.method_5816()) {
						float speed = beltItem.getSpeed(belt);
						player.method_5724(player.field_7503.field_7479 ? speed : speed, new class_243(0, 0, 1));
						beltItem.onMovedTick(belt, player);

						if (player.field_6012 % COST_INTERVAL == 0) {
							ManaItemHandler.instance().requestManaExact(belt, player, COST, true);
						}
					} else {
						beltItem.onNotMovingTick(belt, player);
					}
				}

				if (player.method_5715()) {
					player.field_6013 = 0.60001F; // Not 0.6F because that is the default
				} else {
					player.field_6013 = 1.25F;
				}

			} else {
				player.field_6013 = 0.6F;
				playersWithStepup.remove(s);
			}
		} else if (shouldPlayerHaveStepup(player)) {
			playersWithStepup.add(s);
			player.field_6013 = 1.25F;
		}
	}

	public float getSpeed(class_1799 stack) {
		return speed;
	}

	public void onMovedTick(class_1799 stack, class_1657 player) {}

	public void onNotMovingTick(class_1799 stack, class_1657 player) {}

	public void onPlayerJump(class_1309 living) {
		if (living instanceof class_1657) {
			class_1657 player = (class_1657) living;
			class_1799 belt = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, player);

			if (!belt.method_7960() && ManaItemHandler.instance().requestManaExact(belt, player, COST, false)) {
				player.method_18799(player.method_18798().method_1031(0, ((ItemTravelBelt) belt.method_7909()).jump, 0));
			}
		}
	}

	private static boolean shouldPlayerHaveStepup(class_1657 player) {
		class_1799 result = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, player);
		return !result.method_7960() && ManaItemHandler.instance().requestManaExact(result, player, COST, false);
	}

	public static void playerLoggedOut(class_3244 handler, MinecraftServer server) {
		String username = handler.field_14140.method_7334().getName();
		playersWithStepup.remove(username + ":false");
		playersWithStepup.remove(username + ":true");
	}

	public static String playerStr(class_1657 player) {
		return player.method_7334().getName() + ":" + player.field_6002.field_9236;
	}

	@Environment(EnvType.CLIENT)
	class_2960 getRenderTexture() {
		return texture;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		AccessoryRenderHelper.rotateIfSneaking(ms, player);
		ms.method_22904(0F, 0.2F, 0F);

		float s = 0.85F;
		ms.method_22905(s, s, s);
		if (model == null) {
			model = new class_572<>(1F);
		}

		class_2960 texture = ((ItemTravelBelt) stack.method_7909()).getRenderTexture();
		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.field_3391.method_22699(ms, buffer, light, class_4608.field_21444, 1, 1, 1, 1);
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

}
