/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.Vector3;

import java.util.List;

public class ItemTinyPlanet extends ItemBauble {

	public ItemTinyPlanet(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 player) {
		double x = player.method_23317();
		double y = player.method_23318() + player.method_5751();
		double z = player.method_23321();

		applyEffect(player.field_6002, x, y, z);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		bipedModel.field_3398.method_22703(ms);
		ms.method_22904(-0.25, -0.4, 0);
		ms.method_22905(0.5F, -0.5F, -0.5F);
		class_310.method_1551().method_1541().method_3353(ModBlocks.tinyPlanet.method_9564(), ms, buffers, light, class_4608.field_21444);
	}

	public static void applyEffect(class_1937 world, double x, double y, double z) {
		int range = 8;
		List<class_1682> entities = world.method_8390(class_1682.class, new class_238(x - range, y - range, z - range, x + range, y + range, z + range), Predicates.instanceOf(IManaBurst.class));
		for (class_1682 entity : entities) {
			IManaBurst burst = (IManaBurst) entity;
			class_1799 lens = burst.getSourceLens();
			if (lens != null && lens.method_7909() instanceof ITinyPlanetExcempt && !((ITinyPlanetExcempt) lens.method_7909()).shouldPull(lens)) {
				continue;
			}

			int orbitTime = burst.getOrbitTime();
			if (orbitTime == 0) {
				burst.setMinManaLoss(burst.getMinManaLoss() * 3);
			}

			float radius = Math.min(7.5F, (Math.max(40, orbitTime) - 40) / 40F + 1.5F);
			int angle = orbitTime % 360;

			float xTarget = (float) (x + Math.cos(angle * 10 * Math.PI / 180F) * radius);
			float yTarget = (float) y;
			float zTarget = (float) (z + Math.sin(angle * 10 * Math.PI / 180F) * radius);

			Vector3 targetVec = new Vector3(xTarget, yTarget, zTarget);
			Vector3 currentVec = new Vector3(entity.method_23317(), entity.method_23318(), entity.method_23321());
			Vector3 moveVector = targetVec.subtract(currentVec);

			burst.setBurstMotion(moveVector.x, moveVector.y, moveVector.z);

			burst.setOrbitTime(burst.getOrbitTime() + 1);
		}
	}

}
