/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSwapRing extends ItemBauble {

	public ItemSwapRing(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 entity) {
		if (entity.field_6002.field_9236 && !(entity instanceof class_1657)) {
			return;
		}

		class_1657 player = (class_1657) entity;
		class_1799 currentStack = player.method_6047();
		if (currentStack.method_7960() || !(currentStack.method_7909() instanceof ISortableTool)) {
			return;
		}

		ISortableTool tool = (ISortableTool) currentStack.method_7909();

		class_3965 pos = ToolCommons.raytraceFromEntity(player, 4.5F, false);

		class_3494<class_1792> typeToFind;
		class_2680 state;
		if (player.field_6252 && pos.method_17783() == class_239.class_240.field_1332) {
			state = entity.field_6002.method_8320(pos.method_17777());

			class_3614 mat = state.method_26207();
			if (ToolCommons.materialsPick.contains(mat)) {
				typeToFind = FabricToolTags.PICKAXES;
			} else if (ToolCommons.materialsShovel.contains(mat)) {
				typeToFind = FabricToolTags.SHOVELS;
			} else if (ToolCommons.materialsAxe.contains(mat)) {
				typeToFind = FabricToolTags.AXES;
			} else {
				return;
			}
		} else {
			return;
		}

		class_1799 bestTool = currentStack;
		int bestToolPriority = currentStack.method_7909().method_7855(typeToFind) ? tool.getSortingPriority(currentStack, state) : -1;
		int bestSlot = -1;

		for (int i = 0; i < player.field_7514.method_5439(); i++) {
			class_1799 stackInSlot = player.field_7514.method_5438(i);
			if (!stackInSlot.method_7960() && stackInSlot.method_7909() instanceof ISortableTool && stackInSlot != currentStack) {
				ISortableTool toolInSlot = (ISortableTool) stackInSlot.method_7909();
				if (stackInSlot.method_7909().method_7855(typeToFind)) {
					int priority = toolInSlot.getSortingPriority(stackInSlot, state);
					if (priority > bestToolPriority) {
						bestTool = stackInSlot;
						bestToolPriority = priority;
						bestSlot = i;
					}
				}
			}
		}

		if (bestSlot != -1) {
			player.method_6122(class_1268.field_5808, bestTool);
			player.field_7514.method_5447(bestSlot, currentStack);
		}
	}
}
