/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_809;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.lib.ModTags;

public class ItemMonocle extends ItemBauble implements ICosmeticBauble {

	public ItemMonocle(class_1793 props) {
		super(props);
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		bipedModel.field_3398.method_22703(ms);
		ms.method_22904(0.15, -0.2, -0.25);
		ms.method_22905(0.3F, -0.3F, -0.3F);
		class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315, light, class_4608.field_21444, ms, buffers);
	}

	@Environment(EnvType.CLIENT)
	public static void renderHUD(class_4587 ms, class_1657 player) {
		class_310 mc = class_310.method_1551();
		class_239 ray = mc.field_1765;
		if (ray == null || ray.method_17783() != class_239.class_240.field_1332) {
			return;
		}
		class_2338 pos = ((class_3965) ray).method_17777();
		class_2680 state = player.field_6002.method_8320(pos);
		class_2248 block = state.method_26204();
		player.field_6002.method_8321(pos);

		class_1799 dispStack = class_1799.field_8037;
		String text = "";

		if (block == class_2246.field_10091) {
			dispStack = new class_1799(class_1802.field_8725);
			text = class_124.field_1061 + "" + state.method_11654(class_2457.field_11432);
		} else if (block == class_2246.field_10450) {
			dispStack = new class_1799(class_2246.field_10450);
			text = "" + state.method_11654(class_2462.field_11451);
		} else if (block == class_2246.field_10377) {
			dispStack = new class_1799(class_2246.field_10377);
			text = state.method_11654(class_2286.field_10789) == class_2747.field_12578 ? "-" : "+";
		}

		if (dispStack.method_7960()) {
			return;
		}

		int x = mc.method_22683().method_4486() / 2 + 15;
		int y = mc.method_22683().method_4502() / 2 - 8;

		mc.method_1480().method_4023(dispStack, x, y);

		mc.field_1772.method_1720(ms, text, x + 20, y + 4, 0xFFFFFF);
	}

	public static boolean hasMonocle(class_1309 living) {
		return !EquipmentHandler.findOrEmpty(stack -> {
			if (!stack.method_7960()) {
				class_1792 item = stack.method_7909();
				if (item.method_7855(ModTags.Items.BURST_VIEWERS)) {
					return true;
				}
				if (item instanceof ICosmeticAttachable) {
					ICosmeticAttachable attach = (ICosmeticAttachable) item;
					class_1799 cosmetic = attach.getCosmeticItem(stack);
					return !cosmetic.method_7960() && cosmetic.method_7909().method_7855(ModTags.Items.BURST_VIEWERS);
				}
			}
			return false;
		}, living).method_7960();
	}

}
