/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;

public class ItemMiningRing extends ItemBauble implements IManaUsingItem {

	public ItemMiningRing(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 player) {
		if (player instanceof class_1657 && !player.field_6002.field_9236) {
			int manaCost = 5;
			boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, (class_1657) player, manaCost, false);
			if (!hasMana) {
				onUnequipped(stack, player);
			} else {
				if (player.method_6112(class_1294.field_5917) != null) {
					player.method_6016(class_1294.field_5917);
				}

				player.method_6092(new class_1293(class_1294.field_5917, Integer.MAX_VALUE, 1, true, true));
			}

			if (player.field_6251 == 0.25F) {
				ManaItemHandler.instance().requestManaExact(stack, (class_1657) player, manaCost, true);
			}
		}
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 player) {
		class_1293 effect = player.method_6112(class_1294.field_5917);
		if (effect != null && effect.method_5578() == 1) {
			player.method_6016(class_1294.field_5917);
		}
	}

	@Override
	public boolean usesMana(class_1799 stack) {
		return true;
	}

}
