/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.IDurabilityExtension;

import javax.annotation.Nonnull;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_3532;

public class ItemManaRing extends ItemBauble implements IManaItem, IManaTooltipDisplay, IDurabilityExtension {

	protected static final int MAX_MANA = 500000;

	private static final String TAG_MANA = "mana";

	public ItemManaRing(class_1793 props) {
		super(props);
	}

	@Override
	public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> stacks) {
		if (method_7877(tab)) {
			stacks.add(new class_1799(this));

			class_1799 full = new class_1799(this);
			setMana(full, getMaxMana(full));
			stacks.add(full);
		}
	}

	public static void setMana(class_1799 stack, int mana) {
		ItemNBTHelper.setInt(stack, TAG_MANA, mana);
	}

	@Override
	public int getMana(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
	}

	@Override
	public int getMaxMana(class_1799 stack) {
		return MAX_MANA;
	}

	@Override
	public void addMana(class_1799 stack, int mana) {
		setMana(stack, Math.min(getMana(stack) + mana, getMaxMana(stack)));
	}

	@Override
	public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
		return true;
	}

	@Override
	public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
		return true;
	}

	@Override
	public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
		return true;
	}

	@Override
	public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
		return true;
	}

	@Override
	public boolean isNoExport(class_1799 stack) {
		return false;
	}

	@Override
	public float getManaFractionForDisplay(class_1799 stack) {
		return (float) getMana(stack) / (float) getMaxMana(stack);
	}

	@Override
	public boolean showDurability(class_1799 stack) {
		return true;
	}

	@Override
	public double getDurability(class_1799 stack) {
		return 1 - getManaFractionForDisplay(stack);
	}

	@Override
	public int getDurabilityColor(class_1799 stack) {
		return class_3532.method_15369(getManaFractionForDisplay(stack) / 3.0F, 1.0F, 1.0F);
	}
}
