/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.mixin.AccessorItemEntity;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;

public class ItemMagnetRing extends ItemBauble {

	private static final String TAG_COOLDOWN = "cooldown";

	private final int range;

	public ItemMagnetRing(class_1793 props) {
		this(props, 6);
	}

	public ItemMagnetRing(class_1793 props, int range) {
		super(props);
		this.range = range;
	}

	public static void onTossItem(class_1657 player) {
		class_1799 ring = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemMagnetRing, player);
		if (!ring.method_7960()) {
			setCooldown(ring, 100);
		}
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		super.onWornTick(stack, living);

		if (living.method_7325()) {
			return;
		}

		int cooldown = getCooldown(stack);

		if (BotaniaAPI.instance().hasSolegnoliaAround(living)) {
			if (cooldown < 0) {
				setCooldown(stack, 2);
			}
			return;
		}

		if (cooldown <= 0) {
			if (living.method_5715() == ConfigHandler.COMMON.invertMagnetRing.getValue()) {
				double x = living.method_23317();
				double y = living.method_23318() + 0.75;
				double z = living.method_23321();

				int range = ((ItemMagnetRing) stack.method_7909()).range;
				List<class_1542> items = living.field_6002.method_18467(class_1542.class, new class_238(x - range, y - range, z - range, x + range, y + range, z + range));
				int pulled = 0;
				for (class_1542 item : items) {
					if (((ItemMagnetRing) stack.method_7909()).canPullItem(item)) {
						if (pulled > 200) {
							break;
						}

						MathHelper.setEntityMotionFromVector(item, new Vector3(x, y, z), 0.45F);
						if (living.field_6002.field_9236) {
							boolean red = living.field_6002.field_9229.nextBoolean();
							float r = red ? 1F : 0F;
							float b = red ? 0F : 1F;
							SparkleParticleData data = SparkleParticleData.sparkle(1F, r, 0F, b, 3);
							living.field_6002.method_8406(data, item.method_23317(), item.method_23318(), item.method_23321(), 0, 0, 0);
						}
						pulled++;
					}
				}
			}
		} else {
			setCooldown(stack, cooldown - 1);
		}
	}

	private boolean canPullItem(class_1542 item) {
		int pickupDelay = ((AccessorItemEntity) item).getPickupDelay();
		if (!item.method_5805() || pickupDelay >= 40 || BotaniaAPI.instance().hasSolegnoliaAround(item) /* todo 1.16-fabric || item.getPersistentData().getBoolean("PreventRemoteMovement")*/) {
			return false;
		}

		class_1799 stack = item.method_6983();
		if (stack.method_7960() || stack.method_7909() instanceof IManaItem || stack.method_7909() instanceof IRelic || ModTags.Items.MAGNET_RING_BLACKLIST.method_15141(stack.method_7909())) {
			return false;
		}

		class_2338 pos = item.method_24515();

		if (ModTags.Blocks.MAGNET_RING_BLACKLIST.method_15141(item.field_6002.method_8320(pos).method_26204())) {
			return false;
		}

		if (ModTags.Blocks.MAGNET_RING_BLACKLIST.method_15141(item.field_6002.method_8320(pos.method_10074()).method_26204())) {
			return false;
		}

		return true;
	}

	public static int getCooldown(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
	}

	public static void setCooldown(class_1799 stack, int cooldown) {
		ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
	}
}
