/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5134;
import net.minecraft.class_572;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.lib.LibResources;

public class ItemKnockbackBelt extends ItemBauble {

	private static final class_2960 texture = new class_2960(LibResources.MODEL_KNOCKBACK_BELT);
	private static class_572<class_1309> model;

	public ItemKnockbackBelt(class_1793 props) {
		super(props);
	}

	@Override
	public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
		Multimap<class_1320, class_1322> attributes = HashMultimap.create();
		attributes.put(class_5134.field_23718, new class_1322(getBaubleUUID(stack), "Knockback Belt", 1, class_1322.class_1323.field_6328));
		return attributes;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		AccessoryRenderHelper.rotateIfSneaking(ms, living);
		ms.method_22904(0F, 0.2F, 0F);

		float s = 0.85F;
		ms.method_22905(s, s, s);
		if (model == null) {
			model = new class_572<>(1.0F);
		}

		class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
		model.field_3391.method_22698(ms, buffer, light, class_4608.field_21444);
	}
}
