/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import org.apache.commons.lang3.mutable.MutableFloat;

import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.ModelCloak;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemHolyCloak extends ItemBauble {

	private static final class_2960 texture = new class_2960(LibResources.MODEL_HOLY_CLOAK);
	private static final class_2960 textureGlow = new class_2960(LibResources.MODEL_HOLY_CLOAK_GLOW);

	@Environment(EnvType.CLIENT)
	private static ModelCloak model;

	private static final String TAG_COOLDOWN = "cooldown";
	private static final String TAG_IN_EFFECT = "inEffect";

	public ItemHolyCloak(class_1793 props) {
		super(props);
	}

	public float onPlayerDamage(class_1657 player, class_1282 src, float amount) {
		if (!src.method_5538()) {
			class_1799 stack = EquipmentHandler.findOrEmpty(this, player);

			if (!stack.method_7960() && !isInEffect(stack)) {
				ItemHolyCloak cloak = (ItemHolyCloak) stack.method_7909();
				int cooldown = getCooldown(stack);

				// Used to prevent StackOverflows with mobs that deal damage when damaged
				setInEffect(stack, true);
				MutableFloat mutAmount = new MutableFloat(amount);
				if (cooldown == 0 && cloak.effectOnDamage(src, mutAmount, player, stack)) {
					setCooldown(stack, cloak.getCooldownTime(stack));
				}
				setInEffect(stack, false);
				return mutAmount.getValue();
			}
		}
		return amount;
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		int cooldown = getCooldown(stack);
		if (cooldown > 0) {
			setCooldown(stack, cooldown - 1);
		}
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
		ItemHolyCloak item = ((ItemHolyCloak) stack.method_7909());
		AccessoryRenderHelper.rotateIfSneaking(ms, player);
		boolean armor = !player.method_6118(class_1304.field_6174).method_7960();
		ms.method_22904(0F, armor ? -0.07F : -0.01F, 0F);

		if (model == null) {
			model = new ModelCloak();
		}

		class_310.method_1551().method_1531().method_22813(item.getCloakTexture());
		class_4588 buffer = buffers.getBuffer(model.method_23500(item.getCloakTexture()));
		model.method_2828(ms, buffer, light, class_4608.field_21444, 1, 1, 1, 1);

		buffer = buffers.getBuffer(model.method_23500(item.getCloakGlowTexture()));
		model.method_2828(ms, buffer, 0xF000F0, class_4608.field_21444, 1, 1, 1, 1);
	}

	public boolean effectOnDamage(class_1282 src, MutableFloat amount, class_1657 player, class_1799 stack) {
		if (!src.method_5527()) {
			amount.setValue(0);
			player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.holyCloak, class_3419.field_15248, 1F, 1F);
			for (int i = 0; i < 30; i++) {
				double x = player.method_23317() + Math.random() * player.method_17681() * 2 - player.method_17681();
				double y = player.method_23318() + Math.random() * player.method_17682();
				double z = player.method_23321() + Math.random() * player.method_17681() * 2 - player.method_17681();
				boolean yellow = Math.random() > 0.5;
				float r = yellow ? 1F : 0.3F;
				float g = yellow ? 1F : 0.3F;
				float b = yellow ? 0.3F : 1F;
				SparkleParticleData data = SparkleParticleData.sparkle(0.8F + (float) Math.random() * 0.4F, r, g, b, 3);
				player.field_6002.method_8406(data, x, y, z, 0, 0, 0);
			}
			return true;
		}

		return false;
	}

	public int getCooldownTime(class_1799 stack) {
		return 200;
	}

	public static int getCooldown(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
	}

	public static void setCooldown(class_1799 stack, int cooldown) {
		ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
	}

	public static boolean isInEffect(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_IN_EFFECT, false);
	}

	public static void setInEffect(class_1799 stack, boolean effect) {
		ItemNBTHelper.setBoolean(stack, TAG_IN_EFFECT, effect);
	}

	@Environment(EnvType.CLIENT)
	class_2960 getCloakTexture() {
		return texture;
	}

	@Environment(EnvType.CLIENT)
	class_2960 getCloakGlowTexture() {
		return textureGlow;
	}
}
