/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketDodge;

public class ItemDodgeRing extends ItemBauble {

	public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
	public static final int MAX_CD = 20;

	private static boolean oldLeftDown, oldRightDown, oldForwardDown, oldBackDown;
	private static int leftDown, rightDown, forwardDown, backDown;

	public ItemDodgeRing(class_1793 props) {
		super(props);
	}

	@Environment(EnvType.CLIENT)
	public static void onKeyDown() {
		class_310 mc = class_310.method_1551();
		if (mc.field_1724 == null) {
			return;
		}

		class_1799 ringStack = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, mc.field_1724);
		if (ringStack.method_7960() || ItemNBTHelper.getInt(ringStack, TAG_DODGE_COOLDOWN, 0) > 0) {
			return;
		}

		int threshold = 5;
		if (mc.field_1690.field_1913.method_1434() && !oldLeftDown) {
			int oldLeft = leftDown;
			leftDown = ClientTickHandler.ticksInGame;

			if (leftDown - oldLeft < threshold) {
				dodge(mc.field_1724, class_2350.field_11039);
			}
		} else if (mc.field_1690.field_1849.method_1434() && !oldRightDown) {
			int oldRight = rightDown;
			rightDown = ClientTickHandler.ticksInGame;

			if (rightDown - oldRight < threshold) {
				dodge(mc.field_1724, class_2350.field_11034);
			}
		} else if (mc.field_1690.field_1894.method_1434() && !oldForwardDown) {
			int oldForward = forwardDown;
			forwardDown = ClientTickHandler.ticksInGame;

			if (forwardDown - oldForward < threshold) {
				dodge(mc.field_1724, class_2350.field_11043);
			}
		} else if (mc.field_1690.field_1881.method_1434() && !oldBackDown) {
			int oldBack = backDown;
			backDown = ClientTickHandler.ticksInGame;

			if (backDown - oldBack < threshold) {
				dodge(mc.field_1724, class_2350.field_11035);
			}
		}

		oldLeftDown = mc.field_1690.field_1913.method_1434();
		oldRightDown = mc.field_1690.field_1849.method_1434();
		oldForwardDown = mc.field_1690.field_1894.method_1434();
		oldBackDown = mc.field_1690.field_1881.method_1434();
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 player) {
		int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
		if (cd > 0) {
			ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
		}
	}

	private static void dodge(class_1657 player, class_2350 dir) {
		if (player.field_7503.field_7479 || !player.method_24828() || dir == class_2350.field_11036 || dir == class_2350.field_11033) {
			return;
		}

		float yaw = player.field_6031;
		float x = class_3532.method_15374(-yaw * 0.017453292F - (float) Math.PI);
		float z = class_3532.method_15362(-yaw * 0.017453292F - (float) Math.PI);
		if (dir == class_2350.field_11043 || dir == class_2350.field_11035) {
			x = class_3532.method_15362(-yaw * 0.017453292F);
			z = class_3532.method_15374(yaw * 0.017453292F);
		}
		Vector3 lookVec = new Vector3(x, 0, z);
		Vector3 sideVec = lookVec.crossProduct(new Vector3(0, dir == class_2350.field_11039 || dir == class_2350.field_11043 ? 1 : (dir == class_2350.field_11034 || dir == class_2350.field_11035 ? -1 : 0), 0)).multiply(1.25);

		player.method_18799(sideVec.toVector3d());

		PacketDodge.send();
	}

	@Environment(EnvType.CLIENT)
	public static void renderHUD(class_4587 ms, class_1657 player, class_1799 stack, float pticks) {
		int xo = class_310.method_1551().method_22683().method_4486() / 2 - 20;
		int y = class_310.method_1551().method_22683().method_4502() / 2 + 20;

		if (!player.field_7503.field_7479) {
			int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
			int width = Math.min((int) ((cd - pticks) * 2), 40);
			RenderSystem.color4f(1F, 1F, 1F, 1F);
			if (width > 0) {
				class_332.method_25294(ms, xo, y - 2, xo + 40, y - 1, 0x88000000);
				class_332.method_25294(ms, xo, y - 2, xo + width, y - 1, 0xFFFFFFFF);
			}
		}

		RenderSystem.enableAlphaTest();
		RenderSystem.color4f(1F, 1F, 1F, 1F);
	}
}
